/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PerfEventsTab
extends AbstractLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    protected Button chkDefaultEvent;
    protected TabItem[] eventTabItems;
    protected Table[] eventTable;
    protected TabFolder tabFolder;
    private int rawTabIndex = 0;
    private int bpTabIndex = 0;
    protected Text rawText;
    protected Text bpText;
    private Composite top;
    private IProject previousProject = null;

    public Image getImage() {
        return PerfPlugin.getImageDescriptor("icons/event.gif").createImage();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.top = top;
    }

    private void createEventTabs(Composite top, ILaunchConfiguration config) {
        Map<String, List<String>> events = PerfCore.getEventList(config);
        ArrayList<String> tmpTabNames = new ArrayList<String>(events.keySet());
        List<String> SPECIAL_EVENTS = Arrays.asList("Hardware breakpoint", "Raw hardware event descriptor");
        tmpTabNames.removeAll(SPECIAL_EVENTS);
        tmpTabNames.addAll(SPECIAL_EVENTS);
        String[] tabNames = tmpTabNames.toArray(new String[0]);
        this.eventTabItems = new TabItem[tabNames.length];
        this.eventTable = new Table[tabNames.length];
        this.tabFolder = new TabFolder(top, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < tabNames.length) {
            this.eventTabItems[i] = new TabItem(this.tabFolder, 0);
            this.eventTabItems[i].setText(tabNames[i]);
            if (tabNames[i].equals("Hardware breakpoint") || tabNames[i].equals("Raw hardware event descriptor")) {
                Table table;
                Composite c = new Composite((Composite)this.tabFolder, 0);
                c.setLayout((Layout)new GridLayout(2, false));
                this.eventTable[i] = table = new Table(c, 34);
                table.setLayoutData((Object)new GridData(4, 4, true, true));
                table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                Composite right = new Composite(c, 0);
                right.setLayout((Layout)new GridLayout(2, false));
                right.setLayoutData((Object)new GridData(131072, 4, false, true));
                Label l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                Text t = new Text(right, 2052);
                t.setLayoutData((Object)new GridData(4, 128, true, false));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    this.bpTabIndex = i;
                    this.bpText = t;
                    l.setText(Messages.PerfEventsTab_HardwareBreakpoint);
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    this.rawTabIndex = i;
                    this.rawText = t;
                    l.setText(Messages.PerfEventsTab_RawRegisterEncoding);
                }
                Button b = new Button(right, 8);
                b.setText(Messages.PerfEventsTab_Add);
                b.setLayoutData((Object)new GridData(131072, 128, false, false));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        int i = PerfEventsTab.this.tabFolder.getSelectionIndex();
                        if (PerfEventsTab.this.rawTabIndex == i) {
                            new TableItem(PerfEventsTab.this.eventTable[i], 0).setText(PerfEventsTab.this.rawText.getText());
                        } else if (PerfEventsTab.this.bpTabIndex == i) {
                            new TableItem(PerfEventsTab.this.eventTable[i], 0).setText(PerfEventsTab.this.bpText.getText());
                        }
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    l.setText(Messages.PerfEventsTab_ForExample);
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    l.setText(Messages.PerfEventsTab_ForExampleR1A8);
                }
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                b = new Button(right, 8);
                b.setText(Messages.PerfEventsTab_RemoveSelectedEvents);
                b.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.eventTable[PerfEventsTab.this.tabFolder.getSelectionIndex()].remove(PerfEventsTab.this.eventTable[PerfEventsTab.this.tabFolder.getSelectionIndex()].getSelectionIndices());
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                l.setText(Messages.PerfEventsTab_Note);
                l.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                this.eventTabItems[i].setControl((Control)c);
            } else {
                Table table;
                this.eventTable[i] = table = new Table((Composite)this.tabFolder, 32);
                List<String> eventList = events.get(tabNames[i]);
                for (String event : eventList) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(event);
                }
                table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                this.eventTabItems[i].setControl((Control)table);
            }
            ++i;
        }
    }

    private void refreshDefaultEnabled() {
        boolean state = !this.chkDefaultEvent.getSelection();
        Table[] tableArray = this.eventTable;
        int n = this.eventTable.length;
        int n2 = 0;
        while (n2 < n) {
            Table tab = tableArray[n2];
            tab.setEnabled(state);
            ++n2;
        }
    }

    public String getName() {
        return Messages.PerfEventsTab_Events;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        IProject project = this.getProject(config);
        try {
            List selectedEvents;
            List rawhe;
            if (this.previousProject == null || this.previousProject != null && !this.previousProject.equals((Object)project)) {
                Control[] children;
                Control[] controlArray = children = this.top.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                this.createVerticalSpacer(this.top, 1);
                this.chkDefaultEvent = new Button(this.top, 32);
                this.chkDefaultEvent.setText("Default Event");
                this.chkDefaultEvent.setLayoutData((Object)new GridData());
                this.chkDefaultEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.refreshDefaultEnabled();
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                this.createEventTabs(this.top, config);
            }
            this.chkDefaultEvent.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true));
            this.refreshDefaultEnabled();
            List hwbps = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
            if (hwbps != null) {
                int i = 0;
                while (i < this.eventTable.length) {
                    if (this.eventTabItems[i].getText().equals("Hardware breakpoint")) {
                        this.eventTable[i].removeAll();
                        for (Object e : hwbps) {
                            TableItem x = new TableItem(this.eventTable[i], 0);
                            x.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((rawhe = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default)) != null) {
                int i = 0;
                while (i < this.eventTable.length) {
                    if (this.eventTabItems[i].getText().equals("Raw hardware event descriptor")) {
                        this.eventTable[i].removeAll();
                        for (Object e : rawhe) {
                            TableItem x = new TableItem(this.eventTable[i], 0);
                            x.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((selectedEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default)) != null) {
                int i = 0;
                while (i < this.eventTable.length) {
                    TableItem[] tableItemArray = this.eventTable[i].getItems();
                    int n = tableItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem event = tableItemArray[n3];
                        if (selectedEvents.contains(event.getText())) {
                            event.setChecked(true);
                        } else {
                            event.setChecked(false);
                        }
                        ++n3;
                    }
                    ++i;
                }
            }
            this.previousProject = project;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wconfig) {
        int n;
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", this.chkDefaultEvent.getSelection());
        ArrayList<String> selectedEvents = new ArrayList<String>();
        int i = 0;
        while (i < this.eventTable.length) {
            TableItem[] tableItemArray = this.eventTable[i].getItems();
            n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem x = tableItemArray[n2];
                if (x.getChecked()) {
                    selectedEvents.add(x.getText());
                }
                ++n2;
            }
            ++i;
        }
        if (selectedEvents.size() == 0) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", null);
        } else {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", selectedEvents);
        }
        if (!this.chkDefaultEvent.getSelection() && !selectedEvents.isEmpty()) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", true);
        } else {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", false);
        }
        if (selectedEvents.size() <= 0) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        }
        ArrayList<String> hwbps = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.eventTable.length) {
            if (this.eventTabItems[i2].getText().equals("Hardware breakpoint")) {
                TableItem[] tableItemArray = this.eventTable[i2].getItems();
                int n3 = tableItemArray.length;
                n = 0;
                while (n < n3) {
                    TableItem x = tableItemArray[n];
                    hwbps.add(x.getText());
                    ++n;
                }
            }
            ++i2;
        }
        if (hwbps.size() == 0) {
            hwbps = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", hwbps);
        ArrayList<String> rawhwe = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.eventTable.length) {
            if (this.eventTabItems[i3].getText().equals("Raw hardware event descriptor")) {
                TableItem[] tableItemArray = this.eventTable[i3].getItems();
                int n4 = tableItemArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    TableItem x = tableItemArray[n5];
                    rawhwe.add(x.getText());
                    ++n5;
                }
            }
            ++i3;
        }
        if (rawhwe.size() == 0) {
            rawhwe = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", rawhwe);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default);
    }

    private IProject getProject(ILaunchConfiguration config) {
        String name = null;
        try {
            name = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException e) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }
}

