/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class BaseVMCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final List<IVagrantVM> selectedContainers = CommandUtils.getSelectedContainers(selection);
        Job job = new Job(this.getJobName(selectedContainers)){

            protected IStatus run(IProgressMonitor monitor) {
                if (BaseVMCommandHandler.this.confirmed(selectedContainers)) {
                    monitor.beginTask(BaseVMCommandHandler.this.getJobName(selectedContainers), selectedContainers.size());
                    for (IVagrantVM container : selectedContainers) {
                        monitor.setTaskName(BaseVMCommandHandler.this.getTaskName(container));
                        BaseVMCommandHandler.this.executeInJob(container, monitor);
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    void openError(String errorMessage, Exception e) {
        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)errorMessage, (String)e.getMessage()));
    }

    boolean confirmed(List<IVagrantVM> selectedContainers) {
        return true;
    }

    abstract String getJobName(List<IVagrantVM> var1);

    abstract String getTaskName(IVagrantVM var1);

    abstract void executeInJob(IVagrantVM var1, IProgressMonitor var2);
}

