/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.vagrant.ui.views.VagrantBoxView;
import org.eclipse.linuxtools.internal.vagrant.ui.views.VagrantVMView;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CommandUtils {
    public static void asyncRefresh(Viewer viewer) {
        Display.getDefault().asyncExec(() -> {
            if (viewer != null && !viewer.getControl().isDisposed()) {
                viewer.refresh();
            }
        });
    }

    public static List<IVagrantVM> getSelectedContainers(IWorkbenchPart activePart) {
        if (activePart instanceof VagrantVMView) {
            ISelection selection = ((VagrantVMView)activePart).getSelection();
            return CommandUtils.getSelectedContainers(selection);
        }
        return Collections.emptyList();
    }

    public static List<IVagrantVM> getSelectedContainers(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<IVagrantVM> selectedContainers = new ArrayList<IVagrantVM>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IVagrantVM)) continue;
                selectedContainers.add((IVagrantVM)selectedElement);
            }
            return Collections.unmodifiableList(selectedContainers);
        }
        return Collections.emptyList();
    }

    public static List<IVagrantBox> getSelectedImages(IWorkbenchPart activePart) {
        if (activePart instanceof VagrantBoxView) {
            ISelection selection = ((VagrantBoxView)activePart).getSelection();
            return CommandUtils.getSelectedImages(selection);
        }
        return Collections.emptyList();
    }

    public static List<IVagrantBox> getSelectedImages(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<IVagrantBox> selectedImages = new ArrayList<IVagrantBox>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IVagrantBox)) continue;
                selectedImages.add((IVagrantBox)selectedElement);
            }
            return Collections.unmodifiableList(selectedImages);
        }
        return Collections.emptyList();
    }

    public static boolean openWizard(IWizard wizard, Shell shell) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard, Shell shell, int width, int height) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.setPageSize(width, height);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static void delete(File root) {
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory() && child.canRead()) {
                    CommandUtils.delete(child);
                } else {
                    child.delete();
                }
                ++n2;
            }
        }
        root.delete();
    }
}

