/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.internal.launch.MavenFileEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConsoleLineTracker
implements IConsoleLineTracker {
    private static final Logger log = LoggerFactory.getLogger(MavenConsoleLineTracker.class);
    private static final String PLUGIN_ID = "org.eclipse.m2e.launching";
    private static final String LISTENING_MARKER = "Listening for transport dt_socket at address: ";
    private static final String RUNNING_MARKER = "Running ";
    private static final String TEST_TEMPLATE = "(?:  )test.+\\(([\\w\\.]+)\\)";
    private static final Pattern PATTERN2 = Pattern.compile("(?:  )test.+\\(([\\w\\.]+)\\)");
    private IConsole console;

    public void init(IConsole console) {
        this.console = console;
    }

    public void lineAppended(IRegion line) {
        IProcess process = this.console.getProcess();
        ILaunch launch = process.getLaunch();
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null && this.isMavenProcess(launchConfiguration)) {
            try {
                String baseDir;
                int offset = line.getOffset();
                int length = line.getLength();
                String text = this.console.getDocument().get(offset, length);
                String testName = null;
                int index = text.indexOf(RUNNING_MARKER);
                if (index > -1) {
                    testName = text.substring(RUNNING_MARKER.length());
                    offset += RUNNING_MARKER.length();
                } else if (text.startsWith(LISTENING_MARKER)) {
                    baseDir = this.getBaseDir(launchConfiguration);
                    if (baseDir != null) {
                        String portString = text.substring(LISTENING_MARKER.length()).trim();
                        MavenDebugHyperLink link = new MavenDebugHyperLink(baseDir, portString);
                        this.console.addLink((IHyperlink)link, offset, LISTENING_MARKER.length() + portString.length());
                    }
                } else {
                    Matcher m = PATTERN2.matcher(text);
                    if (m.find()) {
                        testName = m.group(1);
                        offset += m.start(1);
                    }
                }
                if (testName != null && (baseDir = this.getBaseDir(launchConfiguration)) != null) {
                    MavenConsoleHyperLink link = new MavenConsoleHyperLink(baseDir, testName);
                    this.console.addLink((IHyperlink)link, offset, testName.length());
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private String getBaseDir(ILaunchConfiguration launchConfiguration) throws CoreException {
        return launchConfiguration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, null);
    }

    public void dispose() {
    }

    private boolean isMavenProcess(ILaunchConfiguration launchConfiguration) {
        try {
            ILaunchConfigurationType type = launchConfiguration.getType();
            return PLUGIN_ID.equals(type.getPluginIdentifier());
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    static void launchRemoteJavaApp(String baseDir, String portString) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "Connecting debugger to port " + portString);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        HashMap<String, String> connectMap = new HashMap<String, String>();
        connectMap.put("port", portString);
        connectMap.put("hostname", "localhost");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
        IProject project = MavenConsoleLineTracker.getProject(baseDir);
        if (project != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
        DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"debug");
    }

    static IProject getProject(String baseDir) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
        int n = iMavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade projectFacade = iMavenProjectFacadeArray[n2];
            IContainer base = projectFacade.getPom().getParent();
            String baseLocation = base.getLocation().toPortableString();
            if (baseDir.equals(baseLocation)) {
                return projectFacade.getProject();
            }
            ++n2;
        }
        return null;
    }

    public class MavenConsoleHyperLink
    implements IHyperlink {
        private final String baseDir;
        private final String testName;

        public MavenConsoleHyperLink(String baseDir, String testName) {
            this.baseDir = baseDir;
            this.testName = testName;
        }

        public void linkActivated() {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(this.baseDir);
            ds.setIncludes(new String[]{"**/" + this.testName + ".txt"});
            ds.scan();
            String[] includedFiles = ds.getIncludedFiles();
            if (includedFiles != null && includedFiles.length > 0) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.txt");
                File reportFile = new File(this.baseDir, includedFiles[0]);
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new MavenFileEditorInput(reportFile.getAbsolutePath()), (String)desc.getId());
                }
                catch (PartInitException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    public class MavenDebugHyperLink
    implements IHyperlink {
        private final String baseDir;
        private final String portString;

        public MavenDebugHyperLink(String baseDir, String portString) {
            this.baseDir = baseDir;
            this.portString = portString;
        }

        public void linkActivated() {
            try {
                MavenConsoleLineTracker.launchRemoteJavaApp(this.baseDir, this.portString);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }
}

