/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.wtp.overlay.internal.Messages;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IFilteredVirtualFolder;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeVirtualFolder
implements IFilteredVirtualFolder {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeVirtualFolder.class);
    private FlatVirtualComponent flatVirtualComponent;
    private IPath runtimePath;
    private IProject project;
    private Set<IVirtualReference> references = new LinkedHashSet<IVirtualReference>();
    private IVirtualResource[] members;
    private IResourceFilter filter;

    public CompositeVirtualFolder(FlatVirtualComponent aFlatVirtualComponent, IPath aRuntimePath, IResourceFilter filter) {
        this.flatVirtualComponent = aFlatVirtualComponent;
        if (this.flatVirtualComponent != null && this.flatVirtualComponent.getComponent() != null) {
            this.project = this.flatVirtualComponent.getComponent().getProject();
        }
        this.runtimePath = aRuntimePath;
        this.filter = filter;
        try {
            this.treeWalk();
        }
        catch (CoreException e) {
            LOG.error(Messages.CompositeVirtualFolder_Error_Scanning, (Throwable)e);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getRuntimePath() {
        return this.runtimePath;
    }

    public IVirtualResource[] members() throws CoreException {
        if (this.members == null) {
            this.members = new IVirtualResource[0];
        }
        return this.members;
    }

    public void treeWalk() throws CoreException {
        IFlatResource[] flatResources = this.flatVirtualComponent.fetchResources();
        ArrayList<IVirtualResource> membersList = new ArrayList<IVirtualResource>(flatResources.length);
        IFlatResource[] iFlatResourceArray = flatResources;
        int n = flatResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFlatResource flatResource = iFlatResourceArray[n2];
            IVirtualResource resource = this.convert(flatResource);
            if (resource != null) {
                membersList.add(resource);
            }
            ++n2;
        }
        iFlatResourceArray = this.flatVirtualComponent.getChildModules();
        n = iFlatResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IFlatResource childModule = iFlatResourceArray[n2];
            IVirtualReference reference = childModule.getReference();
            if (reference != null) {
                String filePath = this.getFilePath(reference);
                if (this.filter == null || this.filter.accepts(filePath, true)) {
                    this.references.add(reference);
                }
            }
            ++n2;
        }
        this.members = new IVirtualResource[membersList.size()];
        membersList.toArray(this.members);
    }

    private IVirtualResource convert(IFlatResource flatResource) {
        IVirtualFolder virtualResource = null;
        if (flatResource instanceof IFlatFolder) {
            virtualResource = this.convertFolder((IFlatFolder)flatResource);
        } else if (flatResource instanceof IFlatFile) {
            virtualResource = this.convertFile((IFlatFile)flatResource);
        }
        return virtualResource;
    }

    private IVirtualFolder convertFolder(IFlatFolder flatFolder) {
        IFlatResource[] flatMembers = flatFolder.members();
        ArrayList<IVirtualResource> membersList = new ArrayList<IVirtualResource>(flatMembers.length);
        IFlatResource[] iFlatResourceArray = flatMembers;
        int n = flatMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IFlatResource flatResource = iFlatResourceArray[n2];
            IVirtualResource resource = this.convert(flatResource);
            if (resource != null) {
                membersList.add(resource);
            }
            ++n2;
        }
        final IVirtualResource[] folderMembers = new IVirtualResource[membersList.size()];
        membersList.toArray(folderMembers);
        VirtualFolder vf = new VirtualFolder(this.project, flatFolder.getModuleRelativePath().append(flatFolder.getName())){

            public IVirtualResource[] members() throws CoreException {
                return folderMembers;
            }
        };
        return vf;
    }

    private IVirtualFile convertFile(IFlatFile flatFile) {
        final IFile f = (IFile)flatFile.getAdapter(IFile.class);
        String filePath = null;
        if (f == null) {
            File underlyingFile = (File)flatFile.getAdapter(File.class);
            if (underlyingFile != null && underlyingFile.exists()) {
                filePath = String.valueOf(flatFile.getModuleRelativePath().toPortableString()) + '/' + underlyingFile.getName();
                if (this.filter == null || this.filter.accepts(filePath, true)) {
                    IVirtualReference reference = this.createReference(underlyingFile, flatFile.getModuleRelativePath());
                    this.references.add(reference);
                }
            }
        } else {
            final String fileName = f.getName();
            IPath ffRuntimePath = flatFile.getModuleRelativePath();
            filePath = String.valueOf(ffRuntimePath.toPortableString()) + '/' + fileName;
            if (this.filter == null || this.filter.accepts(filePath, true)) {
                return new VirtualFile(this.project, ffRuntimePath, f){

                    public String getName() {
                        return fileName;
                    }

                    public IPath getWorkspaceRelativePath() {
                        return f.getFullPath();
                    }

                    public IFile getUnderlyingFile() {
                        IFile f2 = super.getUnderlyingFile();
                        return f2;
                    }
                };
            }
        }
        return null;
    }

    private IVirtualReference createReference(File underlyingFile, IPath path) {
        VirtualArchiveComponent archive = new VirtualArchiveComponent(this.project, "lib/" + underlyingFile.getAbsolutePath(), path);
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)this.flatVirtualComponent.getComponent(), (IVirtualComponent)archive);
        ref.setArchiveName(archive.getArchivePath().lastSegment());
        ref.setRuntimePath(path);
        return ref;
    }

    public void create(int arg0, IProgressMonitor arg1) throws CoreException {
    }

    public boolean exists(IPath arg0) {
        return false;
    }

    public IVirtualResource findMember(String sPath) {
        return this.findMember((IPath)new Path(sPath), 0);
    }

    public IVirtualResource findMember(String sPath, int searchFlags) {
        return this.findMember((IPath)new Path(sPath), searchFlags);
    }

    public IVirtualResource findMember(IPath path) {
        return this.findMember(path, 0);
    }

    public IVirtualResource findMember(IPath path, int theSearchFlags) {
        if (path == null) {
            return null;
        }
        ArrayDeque<String> segments = new ArrayDeque<String>(path.segmentCount());
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            segments.add(s);
            ++n2;
        }
        try {
            return CompositeVirtualFolder.findMember(segments, this.members);
        }
        catch (CoreException ce) {
            LOG.error(Messages.CompositeVirtualFolder_Error_Finding_Member, (Throwable)ce);
            return null;
        }
    }

    private static IVirtualResource findMember(Queue<String> segments, IVirtualResource[] members) throws CoreException {
        if (segments.isEmpty()) {
            return null;
        }
        String segment = segments.poll();
        boolean finalResource = segments.isEmpty();
        IVirtualResource[] iVirtualResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualResource m = iVirtualResourceArray[n2];
            if (m.getName().equals(segment)) {
                if (finalResource) {
                    return m;
                }
                if (m instanceof IVirtualFolder) {
                    return CompositeVirtualFolder.findMember(segments, ((IVirtualFolder)m).members());
                }
            }
            ++n2;
        }
        return null;
    }

    public IVirtualFile getFile(IPath arg0) {
        return null;
    }

    public IVirtualFile getFile(String arg0) {
        return null;
    }

    public IVirtualFolder getFolder(IPath arg0) {
        return null;
    }

    public IVirtualFolder getFolder(String arg0) {
        return null;
    }

    public IVirtualResource[] getResources(String arg0) {
        return null;
    }

    public IVirtualResource[] members(int arg0) throws CoreException {
        return null;
    }

    public void createLink(IPath arg0, int arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void delete(int arg0, IProgressMonitor arg1) throws CoreException {
    }

    public boolean exists() {
        return false;
    }

    public IVirtualComponent getComponent() {
        return null;
    }

    public String getFileExtension() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IVirtualContainer getParent() {
        return null;
    }

    public IPath getProjectRelativePath() {
        return null;
    }

    public String getResourceType() {
        return null;
    }

    public int getType() {
        return 0;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IResource[] getUnderlyingResources() {
        return null;
    }

    public IPath getWorkspaceRelativePath() {
        return null;
    }

    public boolean isAccessible() {
        return false;
    }

    public void removeLink(IPath arg0, int arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void setResourceType(String arg0) {
    }

    public boolean contains(ISchedulingRule rule) {
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IContainer getUnderlyingFolder() {
        return null;
    }

    public IContainer[] getUnderlyingFolders() {
        return null;
    }

    public IVirtualReference[] getReferences() {
        return this.references.toArray(new IVirtualReference[this.references.size()]);
    }

    @Override
    public IResourceFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IResourceFilter filter) {
        this.filter = filter;
    }

    private String getFilePath(IVirtualReference reference) {
        String archiveName;
        StringBuilder path = new StringBuilder();
        String prefix = reference.getRuntimePath().makeRelative().toString();
        path.append(prefix);
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
            path.append("/");
        }
        if ((archiveName = reference.getArchiveName()) == null || archiveName.isEmpty()) {
            archiveName = String.valueOf(reference.getReferencedComponent().getDeployedName()) + ".jar";
        }
        path.append(archiveName);
        return path.toString();
    }
}

