/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.DelegatingMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceMetamodelProvider
extends DelegatingMetamodelProvider {
    private ResourceSet resSet;
    private List<IMetamodelDesc> metamodels;

    public WorkspaceMetamodelProvider(ResourceSet resolutionRSet) {
        this(MetamodelRegistry.getDefaultMetamodelProvider(), resolutionRSet);
    }

    public WorkspaceMetamodelProvider(IMetamodelProvider delegate, ResourceSet resolutionRSet) {
        super(delegate);
        if (resolutionRSet == null) {
            throw new IllegalArgumentException("Null resolution resource set");
        }
        this.resSet = resolutionRSet;
        this.metamodels = new ArrayList<IMetamodelDesc>();
    }

    public IMetamodelDesc addMetamodel(String metamodelID, URI metamodelResourceURI) {
        if (metamodelID == null) {
            throw new IllegalArgumentException("Null metamodel ID");
        }
        if (metamodelResourceURI == null) {
            throw new IllegalArgumentException("Null metamodel resource URI");
        }
        DescImpl ePackageDesc = new DescImpl(metamodelResourceURI, this.resSet);
        EmfMetamodelDesc desc = new EmfMetamodelDesc(ePackageDesc, metamodelID);
        this.metamodels.add(desc);
        return desc;
    }

    @Override
    protected IMetamodelDesc[] getLocalMetamodels() {
        return this.metamodels.toArray(new IMetamodelDesc[this.metamodels.size()]);
    }

    public static List<IResource> collectWorkspaceMetamodels() {
        final ArrayList<IResource> result = new ArrayList<IResource>();
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && MetamodelRegistry.isMetamodelFileName(proxy.getName())) {
                        result.add(proxy.requestResource());
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            EmfUtilPlugin.log(e);
        }
        return result;
    }

    public static EPackage loadResourceMetamodel(String uriStr) {
        return WorkspaceMetamodelProvider.loadResourceMetamodel(uriStr, (ResourceSet)new ResourceSetImpl());
    }

    public static EPackage loadResourceMetamodel(String uriStr, ResourceSet rs) {
        return new DescImpl(URI.createURI((String)uriStr), rs).getEPackage();
    }

    public static EPackage getFirstEPackageContent(Resource resource) {
        for (EObject content : resource.getContents()) {
            if (!(content instanceof EPackage)) continue;
            return (EPackage)content;
        }
        return null;
    }

    private static class DescImpl
    implements EPackage.Descriptor {
        private final URI uri;
        private final ResourceSet rs;

        public DescImpl(URI modelResourceUri, ResourceSet resSet) {
            assert (modelResourceUri != null);
            assert (resSet != null);
            this.uri = modelResourceUri;
            this.rs = resSet;
        }

        public EFactory getEFactory() {
            return this.getEPackage().getEFactoryInstance();
        }

        public EPackage getEPackage() {
            return this.loadPackage();
        }

        private EPackage loadPackage() {
            EObject eObject = null;
            if (this.uri.hasFragment()) {
                eObject = this.rs.getEObject(this.uri, true);
            }
            if (eObject == null) {
                Resource res = this.rs.getResource(this.uri, true);
                eObject = WorkspaceMetamodelProvider.getFirstEPackageContent(res);
            }
            if (eObject instanceof EPackage) {
                return (EPackage)eObject;
            }
            throw new WrappedException((Exception)new RuntimeException(NLS.bind((String)Messages.WorskpaceMetamodelProvider_URINotReferringMetamodel, (Object)this.uri)));
        }
    }
}

