/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackboxRegistry {
    public static final BlackboxRegistry INSTANCE = EMFPlugin.IS_ECLIPSE_RUNNING ? new Eclipse() : new BlackboxRegistry();
    private final StandaloneBlackboxProvider fStandaloneProvider = new StandaloneBlackboxProvider();
    private final List<AbstractBlackboxProvider> fProviders = Collections.singletonList(this.fStandaloneProvider);

    protected List<? extends AbstractBlackboxProvider> getProviders() {
        return this.fProviders;
    }

    public AbstractCompilationUnitDescriptor getCompilationUnitDescriptor(String qualifiedName, ResolutionContext context) {
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.getProviders()) {
            AbstractCompilationUnitDescriptor descriptor = abstractBlackboxProvider.getModuleDescriptor(qualifiedName, context);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (descriptor == null) {
            throw new IllegalArgumentException("Null blackbox descriptor");
        }
        AbstractBlackboxProvider provider = descriptor.getProvider();
        return provider.loadCompilationUnit(descriptor, loadContext);
    }

    public List<AbstractCompilationUnitDescriptor> getCompilationUnitDescriptors(ResolutionContext loadContext) {
        ArrayList<AbstractCompilationUnitDescriptor> result = new ArrayList<AbstractCompilationUnitDescriptor>();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.getProviders()) {
            for (AbstractCompilationUnitDescriptor abstractCompilationUnitDescriptor : abstractBlackboxProvider.getModuleDescriptors(loadContext)) {
                result.add(abstractCompilationUnitDescriptor);
            }
        }
        return result;
    }

    public void cleanup() {
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.getProviders()) {
            abstractBlackboxProvider.cleanup();
        }
    }

    public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation operation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.getProviders()) {
            Collection<CallHandler> handlers = abstractBlackboxProvider.getBlackboxCallHandler(operation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractBlackboxProvider abstractBlackboxProvider : this.getProviders()) {
            Collection<CallHandler> handlers = abstractBlackboxProvider.getBlackboxCallHandler(transformation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public void addStandaloneModule(Class<?> cls, String unitQualifiedName, String moduleName, String[] packageURIs) {
        this.fStandaloneProvider.registerDescriptor(cls, unitQualifiedName, moduleName, packageURIs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Eclipse
    extends BlackboxRegistry {
        private static final String CLASS_ATTR = "class";
        private static final String PROVIDER_ELEMENT = "provider";
        private static final String BLACKBOX_PROVIDER_EXTENSION = "blackboxProvider";
        private final List<AbstractBlackboxProvider> fProviders = new LinkedList<AbstractBlackboxProvider>();

        @Override
        protected List<? extends AbstractBlackboxProvider> getProviders() {
            return this.fProviders;
        }

        Eclipse() {
            this.readProviders(this.fProviders);
            this.fProviders.addAll(super.getProviders());
        }

        private void readProviders(List<AbstractBlackboxProvider> providers) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", BLACKBOX_PROVIDER_EXTENSION);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    if (element.getName().equals(PROVIDER_ELEMENT)) {
                        Object extension = element.createExecutableExtension(CLASS_ATTR);
                        if (!(extension instanceof AbstractBlackboxProvider)) {
                            QvtPlugin.error("Provider must implement AbstractBlackboxProvider interface: " + extension);
                        } else {
                            providers.add((AbstractBlackboxProvider)extension);
                        }
                    }
                }
                catch (CoreException e) {
                    QvtPlugin.getDefault().log(e.getStatus());
                }
                catch (RuntimeException e) {
                    QvtPlugin.error(e);
                }
                ++n2;
            }
        }
    }
}

