/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.IOException;
import java.net.URL;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;

public abstract class HttpRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    public HttpRepositorySettingsPage(String title, String description, TaskRepository taskRepository) {
        super(title, description, taskRepository);
        this.setHttpAuth(false);
        this.setNeedsAdvanced(false);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(false);
    }

    protected boolean isValidUrl(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                new URL(url);
                return GitHub.getRepository((String)url) != null;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public boolean canValidate() {
        return this.isPageComplete() && (this.getMessage() == null || this.getMessageType() != 3);
    }
}

