/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TransferList;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.ImportExportUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ImportAction
implements IViewActionDelegate {
    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        ImportStatus result;
        File file;
        FileDialog dialog = new FileDialog(WorkbenchUtil.getShell());
        dialog.setText(Messages.ImportAction_Dialog_Title);
        ImportExportUtil.configureFilter(dialog);
        String path = dialog.open();
        if (path != null && (file = new File(path)).isFile() && !(result = ImportAction.importElements(file)).isOK()) {
            StatusHandler.log((IStatus)result);
            TasksUiInternal.displayStatus(Messages.ImportAction_Dialog_Title, (IStatus)new MultiStatus("org.eclipse.mylyn.tasks.core", 0, new IStatus[]{result}, Messages.ImportAction_Problems_encountered, null));
        }
    }

    public static ImportStatus importElements(File file) {
        TransferList list = new TransferList();
        ImportStatus result = new ImportStatus("org.eclipse.mylyn.tasks.core", 0, "Problems encounted during importing", null);
        result.taskList = list;
        TaskListExternalizer externalizer = TasksUiPlugin.getDefault().createTaskListExternalizer();
        try {
            externalizer.readTaskList((ITransferList)list, file);
        }
        catch (CoreException e) {
            result.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problems encountered reading import file", (Throwable)e));
        }
        TaskList taskList = TasksUiPlugin.getTaskList();
        for (AbstractTask task : list.getAllTasks()) {
            if (!ImportAction.validateRepository(task.getConnectorKind(), task.getRepositoryUrl())) {
                result.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Task {0} ignored, unknown connector", (Object)task.getSummary())));
                continue;
            }
            if (taskList.getTask(task.getHandleIdentifier()) != null) {
                result.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Task {0} ignored, already exists in Task List", (Object)task.getSummary())));
                continue;
            }
            task.setActive(false);
            taskList.addTask((ITask)task);
        }
        for (RepositoryQuery query : list.getQueries()) {
            if (!ImportAction.validateRepository(query.getConnectorKind(), query.getRepositoryUrl())) {
                result.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Query {0} ignored, unknown connector", (Object)query.getSummary())));
                continue;
            }
            if (taskList.getQueries().contains(query)) {
                query.setHandleIdentifier(taskList.getUniqueHandleIdentifier());
            }
            taskList.addQuery(query);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(query.getConnectorKind());
            if (connector == null) continue;
            TasksUiInternal.synchronizeQuery(connector, query, null, true);
        }
        return result;
    }

    private static boolean validateRepository(String connectorKind, String repositoryUrl) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        if (repository == null) {
            if (TasksUi.getRepositoryConnector(connectorKind) == null) {
                return false;
            }
            repository = new TaskRepository(connectorKind, repositoryUrl);
            TasksUi.getRepositoryManager().addRepository(repository);
        }
        return true;
    }

    public static class ImportStatus
    extends MultiStatus {
        private TransferList taskList;

        public ImportStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        public TransferList getTaskList() {
            return this.taskList;
        }
    }
}

