/*******************************************************************************
 * Copyright (c) 2015 David Green and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     David Green - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.wikitext.textile.core.phrase;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.junit.Test;

public class EscapeTextilePhraseModifierTest {

	@Test
	public void matches() {
		assertMatch(0, "a", "==a==");
		assertMatch(1, "a", " ==a==");
		assertMatch(0, "", "====");
		assertMatch(1, "", " =====");
	}

	private void assertMatch(int offset, String content, String markup) {
		String regex = new EscapeTextilePhraseModifier().getPattern(0);
		Pattern pattern = Pattern.compile(regex);

		Matcher matcher = pattern.matcher(markup);
		assertTrue(matcher.find());
		assertEquals(offset, matcher.start());
		assertEquals(content, matcher.group(1));
	}
}
