/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.AbstractMediaWikiLanguage;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.TemplateProcessor;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.TestWikiTemplateResolver;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.WikiTemplateResolver;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;

public class WikiTemplateResolverTest
extends TestCase {
    private static final String BUG_TEMPLATE_CONTENT = "[https://bugs.eclipse.org/{{{1}}} Bug {{{1}}}]";
    private static final String TEST_TEMPLATE_CONTENT = "XXX";
    private static final String OTHER_TEMPLATE_CONTENT = "alt";
    private WikiTemplateResolver resolver;
    private TemplateProcessor templateProcessor;

    protected void setUp() throws Exception {
        super.setUp();
        TestWikiTemplateResolver resolverUnderTest = new TestWikiTemplateResolver();
        resolverUnderTest.setWikiBaseUrl("http://wiki.eclipse.org");
        HashMap<String, String> serverContent = new HashMap<String, String>();
        serverContent.put("http://wiki.eclipse.org/index.php?title=Template%3Abug&action=raw", BUG_TEMPLATE_CONTENT);
        serverContent.put("http://wiki.eclipse.org/index.php?title=Test&action=raw", TEST_TEMPLATE_CONTENT);
        serverContent.put("http://wiki.eclipse.org/index.php?title=Other%3ATest&action=raw", OTHER_TEMPLATE_CONTENT);
        resolverUnderTest.setServerContent(serverContent);
        MediaWikiLanguage markupLanguage = new MediaWikiLanguage();
        markupLanguage.getTemplateProviders().add(resolverUnderTest);
        this.templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)markupLanguage);
        this.resolver = resolverUnderTest;
    }

    public void testResolveTemplateDefault() {
        Template template = this.resolver.resolveTemplate("bug");
        WikiTemplateResolverTest.assertNotNull((Object)template);
        WikiTemplateResolverTest.assertEquals((String)"bug", (String)template.getName());
        WikiTemplateResolverTest.assertEquals((String)BUG_TEMPLATE_CONTENT, (String)template.getTemplateMarkup().trim());
    }

    public void testResolveTemplateNoNamespace() {
        Template template = this.resolver.resolveTemplate(":Test");
        WikiTemplateResolverTest.assertNotNull((Object)template);
        WikiTemplateResolverTest.assertEquals((String)TEST_TEMPLATE_CONTENT, (String)template.getTemplateMarkup().trim());
    }

    public void testResolveTemplateOtherNamespace() {
        Template template = this.resolver.resolveTemplate("Other:Test");
        WikiTemplateResolverTest.assertNotNull((Object)template);
        WikiTemplateResolverTest.assertEquals((String)"Other:Test", (String)template.getName());
        WikiTemplateResolverTest.assertEquals((String)OTHER_TEMPLATE_CONTENT, (String)template.getTemplateMarkup().trim());
    }

    public void testProcessTemplatesDefault() {
        String markup = this.templateProcessor.processTemplates("See {{bug|468237}}!");
        WikiTemplateResolverTest.assertEquals((String)"See [https://bugs.eclipse.org/468237 Bug 468237]!", (String)markup);
    }

    public void testProcessTemplatesNoNamespace() {
        String markup = this.templateProcessor.processTemplates("Include {{:Test}} content!");
        WikiTemplateResolverTest.assertEquals((String)"Include XXX content!", (String)markup);
    }

    public void testProcessTemplatesOtherNamespace() {
        String markup = this.templateProcessor.processTemplates("Include {{Other:Test}} content!");
        WikiTemplateResolverTest.assertEquals((String)"Include alt content!", (String)markup);
    }
}

