/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.junit.Test;

public class TextileNoTextileTest
extends AbstractMarkupGenerationTest<TextileLanguage> {
    @Override
    protected TextileLanguage createMarkupLanguage() {
        return new TextileLanguage();
    }

    @Test
    public void noTextileWithNestedMarkup() {
        this.assertMarkup("*MyType==[1]==*", "<notextile>*MyType==[1]==*</notextile>");
    }

    @Test
    public void noTextileWithNestedMarkupInParagraph() {
        this.assertMarkup("<p>asdf *MyType==[1]==*</p>", "asdf <notextile>*MyType==[1]==*</notextile>");
    }

    @Test
    public void midParagraph() {
        this.assertMarkup("<p>text with <b>no</b> textile</p>", "text with <notextile><b>no</b></notextile> textile");
    }

    @Test
    public void withoutClosingTag() {
        this.assertMarkup("<b>no</b> textile", "<notextile><b>no</b> textile");
    }

    @Test
    public void multiLine() {
        this.assertMarkup("  one\n<em>two</em>\n", "<notextile>  \none\n<em>two</em>\n</notextile>");
    }
}

