/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;
import org.eclipse.objectteams.otdt.core.search.OTSearchRequestor;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.objectteams.otdt.ui.dialogs.ISearchFilter;
import org.eclipse.objectteams.otdt.ui.dialogs.OTTypeSelectionLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TeamSelectionDialog
extends TwoPaneElementSelector {
    private IJavaSearchScope fScope;
    private List<ISearchFilter> _searchFilters = new LinkedList<ISearchFilter>();

    public TeamSelectionDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ILabelProvider)new OTTypeSelectionLabelProvider());
        assert (context != null);
        assert (scope != null);
        this.fScope = scope;
        this.setUpperListLabel(OTNewWizardMessages.TeamSelectionDialog_upperLabel);
        this.setLowerListLabel(OTNewWizardMessages.TeamSelectionDialog_lowerLabel);
    }

    public void addSearchFilter(ISearchFilter filter) {
        this._searchFilters.add(filter);
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        this.fFilteredList.setComparator((Comparator)new StringComparator());
        return list;
    }

    public int open() {
        OTSearchRequestor requestor = new OTSearchRequestor();
        try {
            SearchPattern teamPattern = OTSearchEngine.createTeamTypePattern((int)5, (int)0);
            new OTSearchEngine().search(teamPattern, this.fScope, (SearchRequestor)requestor, null);
        }
        catch (CoreException ex) {
            OTDTUIPlugin.logException("Problems searching team types", ex);
        }
        catch (InternalCompilerError ex) {
            OTDTUIPlugin.logException("Problems searching team types", ex);
        }
        Object[] teamsInScope = requestor.getOTTypes();
        teamsInScope = this.filterTypes((IOTType[])teamsInScope);
        if (teamsInScope == null || teamsInScope.length == 0) {
            String title = OTNewWizardMessages.TeamSelectionDialog_notypes_title;
            String message = OTNewWizardMessages.TeamSelectionDialog_notypes_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        this.setElements(teamsInScope);
        return super.open();
    }

    protected IOTType[] filterTypes(IOTType[] teamsInScope) {
        IOTType[] filteredTypes = teamsInScope;
        for (ISearchFilter filter : this._searchFilters) {
            filteredTypes = filter.filterTypes(filteredTypes);
        }
        return filteredTypes;
    }

    protected void computeResult() {
        Object tmpRef = this.getLowerSelectedElement();
        if (tmpRef instanceof IOTType) {
            IOTType ref = (IOTType)tmpRef;
            IType type = (IType)ref.getCorrespondingJavaElement();
            ArrayList<IType> result = new ArrayList<IType>(1);
            result.add(type);
            this.setResult(result);
        }
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (Strings.isLowerCase((char)leftString.charAt(0)) && !Strings.isLowerCase((char)rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase((char)rightString.charAt(0)) && !Strings.isLowerCase((char)leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        private TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof IOTType)) {
                return false;
            }
            IOTType type = (IOTType)element;
            if (!this.fMatcher.match(type.getElementName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(this.getContainerName(type));
        }

        public String getContainerName(IOTType type) {
            String qualName = type.getFullyQualifiedName();
            int index = qualName.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            String containerName = qualName.substring(0, index);
            return containerName;
        }

        private String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        pattern = String.valueOf(pattern) + '*';
                    }
                }
            }
            return pattern;
        }
    }
}

