/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NestedTypeId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OclInvalidTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.UnspecifiedId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValue;
import org.eclipse.ocl.pivot.values.RealValue;

public class NameManager {
    public static final String BAG_NAME_HINT_PREFIX = "BAG";
    public static final String COLLECTION_NAME_HINT_PREFIX = "COL";
    public static final String DEFAULT_NAME_PREFIX = "symbol";
    public static final String EXPRESSION_IN_OCL_NAME_HINT_PREFIX = "result";
    public static final String INTEGER_NAME_HINT_PREFIX = "INT_";
    public static final String INVALID_NAME_HINT_PREFIX = "IVE_";
    public static final String ITERATION_NAME_HINT_PREFIX = "";
    public static final String OPERATION_NAME_HINT_PREFIX = "OP_";
    public static final String OPERATION_CALL_EXP_NAME_HINT_PREFIX = "";
    public static final String ORDERED_SET_NAME_HINT_PREFIX = "ORD";
    public static final String PROPERTY_NAME_HINT_PREFIX = "";
    public static final String REAL_NAME_HINT_PREFIX = "REA_";
    public static final String RANGE_NAME_HINT_PREFIX = "RNG";
    public static final String SEQUENCE_NAME_HINT_PREFIX = "SEQ";
    public static final String SET_NAME_HINT_PREFIX = "SET";
    public static final String STRING_NAME_HINT_PREFIX = "STR_";
    public static final int STRING_NAME_HINT_LIMIT = 64;
    public static final String TYPE_NAME_HINT_PREFIX = "TYP_";
    public static final String VARIABLE_DECLARATION_NAME_HINT_PREFIX = "";
    public static final Set<String> reservedJavaNames = new HashSet<String>();
    public static @NonNull IdVisitor<String> idVisitor = new IdVisitor<String>(){

        public @NonNull String visitClassId(@NonNull ClassId id) {
            return "CLSSid_" + id.getName();
        }

        public @NonNull String visitCollectionTypeId(@NonNull CollectionTypeId id) {
            CollectionTypeId generalizedId = id.getGeneralizedId();
            String idPrefix = generalizedId == TypeId.BAG ? "BAG_" : (generalizedId == TypeId.ORDERED_SET ? "ORD_" : (generalizedId == TypeId.SEQUENCE ? "SEQ_" : (generalizedId == TypeId.SET ? "SET_" : "COL_")));
            if (generalizedId == id) {
                return idPrefix;
            }
            return String.valueOf(idPrefix) + (String)id.getElementTypeId().accept((IdVisitor)this);
        }

        public @NonNull String visitDataTypeId(@NonNull DataTypeId id) {
            return "DATAid_" + id.getName();
        }

        public @NonNull String visitEnumerationId(@NonNull EnumerationId id) {
            return "ENUMid_" + id.getName();
        }

        public @NonNull String visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
            return "ELITid_" + id.getName();
        }

        public @NonNull String visitInvalidId(@NonNull OclInvalidTypeId id) {
            return "INVid";
        }

        public @NonNull String visitLambdaTypeId(@NonNull LambdaTypeId id) {
            return "LAMBid_" + id.getName();
        }

        public @NonNull String visitMapTypeId(@NonNull MapTypeId id) {
            MapTypeId generalizedId = id.getGeneralizedId();
            String idPrefix = "MAP_";
            if (generalizedId == id) {
                return idPrefix;
            }
            return String.valueOf(idPrefix) + (String)id.getKeyTypeId().accept((IdVisitor)this) + (String)id.getValueTypeId().accept((IdVisitor)this);
        }

        public @NonNull String visitNestedPackageId(@NonNull NestedPackageId id) {
            return "PACKid_" + id.getName();
        }

        public @NonNull String visitNsURIPackageId(@NonNull NsURIPackageId id) {
            return "PACKid_" + id.getNsURI();
        }

        public @NonNull String visitNullId(@NonNull OclVoidTypeId id) {
            return "NULLid";
        }

        public @NonNull String visitOperationId(@NonNull OperationId id) {
            return "OPid_" + id.getName();
        }

        public @NonNull String visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
            return "PRIMid_" + id.getName();
        }

        public @NonNull String visitPropertyId(@NonNull PropertyId id) {
            return "PROPid_" + id.getName();
        }

        public @NonNull String visitRootPackageId(@NonNull RootPackageId id) {
            return "PACKid_" + id.getName();
        }

        public @NonNull String visitTemplateBinding(@NonNull TemplateBinding id) {
            return "BINDid_";
        }

        public @NonNull String visitTemplateParameterId(@NonNull TemplateParameterId id) {
            return "TMPLid_";
        }

        public @NonNull String visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
            return "TYPEid_";
        }

        public @NonNull String visitTuplePartId(@NonNull TuplePartId id) {
            return "PARTid_";
        }

        public @NonNull String visitTupleTypeId(@NonNull TupleTypeId id) {
            return "TUPLid_";
        }

        public @NonNull String visitUnspecifiedId(@NonNull UnspecifiedId id) {
            return "UNSPid_";
        }
    };
    private @NonNull Context context;

    protected static void appendJavaCharacters(StringBuilder s, String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    protected static void appendJavaCharacters(StringBuilder s, String string, int iMax) {
        int i = 0;
        while (i < Math.min(iMax, string.length())) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    private static @NonNull String getValidJavaIdentifier(@NonNull String nameHint, boolean hasPrefix, @Nullable Object anObject) {
        if (nameHint.equals("<")) {
            return "lt";
        }
        if (nameHint.equals("<=")) {
            return "le";
        }
        if (nameHint.equals("=")) {
            return "eq";
        }
        if (nameHint.equals("<>")) {
            return "ne";
        }
        if (nameHint.equals(">=")) {
            return "ge";
        }
        if (nameHint.equals(">")) {
            return "gt";
        }
        if (nameHint.equals("+")) {
            return "sum";
        }
        if (nameHint.equals("-")) {
            return anObject instanceof Operation && ((Operation)anObject).getOwnedParameters().size() <= 0 ? "neg" : "diff";
        }
        if (nameHint.equals("*")) {
            return "prod";
        }
        if (nameHint.equals("/")) {
            return "quot";
        }
        if (nameHint.equals("1_")) {
            return "_1";
        }
        if (nameHint.equals("2_")) {
            return "_2";
        }
        StringBuilder s = new StringBuilder();
        Character prefix = null;
        int length = nameHint.length();
        int i = 0;
        while (i < length) {
            char c = nameHint.charAt(i);
            if (i == 0 && !hasPrefix ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c)) {
                if (prefix != null) {
                    s.append(prefix);
                    prefix = null;
                }
                s.append(c);
            } else {
                if (c == '*') {
                    s.append("_a");
                } else if (c == ':') {
                    s.append("_c");
                } else if (c == '.') {
                    if (prefix != null) {
                        s.append(prefix);
                        prefix = null;
                    }
                } else if (c == ')') {
                    s.append("_e");
                } else if (c == '>') {
                    s.append("_g");
                } else if (c == '<') {
                    s.append("_l");
                } else if (c == '-') {
                    s.append("_m");
                } else if (c == '(') {
                    s.append("_o");
                } else if (c == '+') {
                    s.append("_p");
                } else if (c == '=') {
                    s.append("_q");
                } else if (c == '/') {
                    s.append("_s");
                } else {
                    s.append(String.valueOf('_') + Integer.toString(c));
                }
                prefix = Character.valueOf('_');
            }
            ++i;
        }
        return s.toString();
    }

    public NameManager() {
        reservedJavaNames.add("Boolean");
        reservedJavaNames.add("Character");
        reservedJavaNames.add("Class");
        reservedJavaNames.add("Double");
        reservedJavaNames.add("Float");
        reservedJavaNames.add("Integer");
        reservedJavaNames.add("List");
        reservedJavaNames.add("Long");
        reservedJavaNames.add("Map");
        reservedJavaNames.add("Package");
        reservedJavaNames.add("String");
        reservedJavaNames.add("boolean");
        reservedJavaNames.add("byte");
        reservedJavaNames.add("char");
        reservedJavaNames.add("double");
        reservedJavaNames.add("float");
        reservedJavaNames.add("int");
        reservedJavaNames.add("long");
        reservedJavaNames.add("short");
        reservedJavaNames.add("void");
        reservedJavaNames.add("abstract");
        reservedJavaNames.add("assert");
        reservedJavaNames.add("break");
        reservedJavaNames.add("case");
        reservedJavaNames.add("catch");
        reservedJavaNames.add("class");
        reservedJavaNames.add("const");
        reservedJavaNames.add("continue");
        reservedJavaNames.add("default");
        reservedJavaNames.add("do");
        reservedJavaNames.add("else");
        reservedJavaNames.add("enum");
        reservedJavaNames.add("extends");
        reservedJavaNames.add("final");
        reservedJavaNames.add("finally");
        reservedJavaNames.add("for");
        reservedJavaNames.add("goto");
        reservedJavaNames.add("if");
        reservedJavaNames.add("implements");
        reservedJavaNames.add("import");
        reservedJavaNames.add("instanceof");
        reservedJavaNames.add("interface");
        reservedJavaNames.add("native");
        reservedJavaNames.add("new");
        reservedJavaNames.add("package");
        reservedJavaNames.add("private");
        reservedJavaNames.add("protected");
        reservedJavaNames.add("public");
        reservedJavaNames.add("return");
        reservedJavaNames.add("static");
        reservedJavaNames.add("strictfp");
        reservedJavaNames.add("switch");
        reservedJavaNames.add("synchronized");
        reservedJavaNames.add("throw");
        reservedJavaNames.add("throws");
        reservedJavaNames.add("transient");
        reservedJavaNames.add("try");
        reservedJavaNames.add("volatile");
        reservedJavaNames.add("while");
        reservedJavaNames.add("false");
        reservedJavaNames.add("null");
        reservedJavaNames.add("super");
        reservedJavaNames.add("this");
        reservedJavaNames.add("true");
        this.context = new Context();
    }

    public @NonNull Context createNestedContext() {
        return new Context(this.context);
    }

    public @NonNull String getExplicitName(@Nullable Object anObject) {
        if (anObject == null) {
            return "null";
        }
        if (anObject instanceof Boolean) {
            return (Boolean)anObject != false ? "true" : "false";
        }
        return "<null-" + anObject.getClass().getSimpleName() + ">";
    }

    public @NonNull String getGlobalSymbolName(@Nullable Object anObject, String ... nameHints) {
        if (nameHints != null && nameHints.length > 0) {
            return this.getGlobalUniqueName(anObject, nameHints);
        }
        return this.getGlobalUniqueName(anObject, anObject != null ? this.getNameHint(anObject) : null);
    }

    protected @NonNull String getGlobalUniqueName(@Nullable Object anObject, String ... nameHints) {
        return this.context.getGlobalUniqueName(anObject, nameHints);
    }

    protected String getIterationNameHint(@NonNull Iteration anIteration) {
        @NonNull String string = anIteration.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, anIteration);
    }

    protected String getKindHint(@NonNull String kind) {
        if ("Bag".equals(kind)) {
            return BAG_NAME_HINT_PREFIX;
        }
        if ("OrderedSet".equals(kind)) {
            return ORDERED_SET_NAME_HINT_PREFIX;
        }
        if ("Sequence".equals(kind)) {
            return SEQUENCE_NAME_HINT_PREFIX;
        }
        if ("Set".equals(kind)) {
            return SET_NAME_HINT_PREFIX;
        }
        return COLLECTION_NAME_HINT_PREFIX;
    }

    public @Nullable String getNameHint(@NonNull Object anObject) {
        if (anObject instanceof CGValuedElement) {
            anObject = ((CGValuedElement)anObject).getNamedValue();
        }
        if (anObject instanceof CollectionLiteralExp) {
            Type type = ((CollectionLiteralExp)anObject).getType();
            return type != null ? this.getTypeNameHint(type) : null;
        }
        if (anObject instanceof CollectionRange) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof CGCollectionPart) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof InvalidValue) {
            return INVALID_NAME_HINT_PREFIX;
        }
        if (anObject instanceof CollectionValue) {
            String kind = ((CollectionValue)anObject).getKind();
            return kind != null ? this.getKindHint(kind) : null;
        }
        if (anObject instanceof CGCollectionExp) {
            String kind = ((CGCollectionExp)anObject).getName();
            return kind != null ? this.getKindHint(kind) : null;
        }
        if (anObject instanceof ElementId) {
            String nameHint = (String)((ElementId)anObject).accept(idVisitor);
            return nameHint;
        }
        if (anObject instanceof ExpressionInOCL) {
            return EXPRESSION_IN_OCL_NAME_HINT_PREFIX;
        }
        if (anObject instanceof IntegerLiteralExp) {
            Number numberSymbol = ((IntegerLiteralExp)anObject).getIntegerSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof IntegerRange) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof IntegerValue) {
            Number numberSymbol = ((IntegerValue)anObject).asNumber();
            return this.getNumericNameHint(numberSymbol);
        }
        if (anObject instanceof LoopExp) {
            Iteration referredIteration = ((LoopExp)anObject).getReferredIteration();
            return referredIteration != null ? this.getIterationNameHint(referredIteration) : null;
        }
        if (anObject instanceof Number) {
            return this.getNumericNameHint((Number)anObject);
        }
        if (anObject instanceof Operation) {
            return this.getOperationNameHint((Operation)anObject);
        }
        if (anObject instanceof OperationCallExp) {
            Operation referredOperation = ((OperationCallExp)anObject).getReferredOperation();
            return referredOperation != null ? this.getOperationCallExpNameHint(referredOperation) : null;
        }
        if (anObject instanceof OppositePropertyCallExp) {
            Property referredOppositeProperty = ((OppositePropertyCallExp)anObject).getReferredProperty();
            Property referredProperty = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
            return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
        }
        if (anObject instanceof PropertyCallExp) {
            Property referredProperty = ((PropertyCallExp)anObject).getReferredProperty();
            return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
        }
        if (anObject instanceof CGCallExp) {
            if (anObject instanceof CGOppositePropertyCallExp) {
                Property referredOppositeProperty = ((OppositePropertyCallExp)((CGOppositePropertyCallExp)anObject).getAst()).getReferredProperty();
                Property referredProperty = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
                return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
            }
            if (anObject instanceof CGPropertyCallExp) {
                Property referredProperty = ((PropertyCallExp)((CGPropertyCallExp)anObject).getAst()).getReferredProperty();
                return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
            }
            if (anObject instanceof CGIterationCallExp) {
                Iteration referredIteration = ((LoopExp)((CGIterationCallExp)anObject).getAst()).getReferredIteration();
                return referredIteration != null ? this.getIterationNameHint(referredIteration) : null;
            }
            if (anObject instanceof CGOperationCallExp) {
                Operation referredOperation = ((OperationCallExp)((CGOperationCallExp)anObject).getAst()).getReferredOperation();
                return referredOperation != null ? this.getOperationCallExpNameHint(referredOperation) : null;
            }
            if (anObject instanceof CGBoxExp) {
                return "BOXED_" + ((CGBoxExp)anObject).getSourceValue().getValueName();
            }
            if (anObject instanceof CGEcoreExp) {
                return "ECORE_" + ((CGEcoreExp)anObject).getSourceValue().getValueName();
            }
            if (anObject instanceof CGUnboxExp) {
                return "UNBOXED_" + ((CGUnboxExp)anObject).getSourceValue().getValueName();
            }
            if (anObject instanceof CGCatchExp) {
                return "CAUGHT_" + ((CGCatchExp)anObject).getSourceValue().getValueName();
            }
            if (anObject instanceof CGGuardExp) {
                return "GUARDED_" + ((CGGuardExp)anObject).getSourceValue().getValueName();
            }
            if (anObject instanceof CGThrowExp) {
                return "THROWN_" + ((CGThrowExp)anObject).getSourceValue().getValueName();
            }
            return null;
        }
        if (anObject instanceof RealLiteralExp) {
            Number numberSymbol = ((RealLiteralExp)anObject).getRealSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof RealValue) {
            Number numberSymbol = ((RealValue)anObject).asNumber();
            return this.getNumericNameHint(numberSymbol);
        }
        if (anObject instanceof String) {
            return this.getStringNameHint((String)anObject);
        }
        if (anObject instanceof CGString) {
            String stringValue = ((CGString)anObject).getStringValue();
            return stringValue != null ? this.getStringNameHint(stringValue) : null;
        }
        if (anObject instanceof StringLiteralExp) {
            String stringSymbol = ((StringLiteralExp)anObject).getStringSymbol();
            return stringSymbol != null ? this.getStringNameHint(stringSymbol) : null;
        }
        if (anObject instanceof Type) {
            return this.getTypeNameHint((Type)anObject);
        }
        if (anObject instanceof CGTypeId) {
            Element type = ((CGTypeId)anObject).getAst();
            return type instanceof Type ? this.getTypeNameHint((Type)type) : null;
        }
        if (anObject instanceof TypeExp) {
            Type referredType = ((TypeExp)anObject).getType();
            return referredType != null ? this.getTypeNameHint(referredType) : null;
        }
        if (anObject instanceof UnlimitedNaturalLiteralExp) {
            Number numberSymbol = ((UnlimitedNaturalLiteralExp)anObject).getUnlimitedNaturalSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof VariableExp) {
            VariableDeclaration referredVariable = ((VariableExp)anObject).getReferredVariable();
            return referredVariable != null ? this.getVariableDeclarationNameHint(referredVariable) : null;
        }
        if (anObject instanceof LiteralExp) {
            return "literal";
        }
        if (anObject instanceof Nameable) {
            String name = ((Nameable)anObject).getName();
            return name != null ? NameManager.getValidJavaIdentifier(name, false, anObject) : null;
        }
        return null;
    }

    protected String getNumericNameHint(@NonNull Number aNumber) {
        @NonNull String string = aNumber.toString();
        if (aNumber instanceof BigInteger || aNumber instanceof Long || aNumber instanceof Integer || aNumber instanceof Short) {
            return INTEGER_NAME_HINT_PREFIX + string;
        }
        if (aNumber instanceof BigDecimal || aNumber instanceof Double || aNumber instanceof Float) {
            return REAL_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, REAL_NAME_HINT_PREFIX.length() > 0, aNumber);
        }
        return null;
    }

    protected String getOperationNameHint(@NonNull Operation anOperation) {
        @NonNull String string = anOperation.toString();
        return OPERATION_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, OPERATION_NAME_HINT_PREFIX.length() > 0, anOperation);
    }

    protected String getOperationCallExpNameHint(@NonNull Operation anOperation) {
        @NonNull String string = anOperation.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, anOperation);
    }

    protected String getPropertyNameHint(@NonNull Property aProperty) {
        @NonNull String string = aProperty.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, aProperty);
    }

    protected String getStringNameHint(@NonNull String aString) {
        @NonNull String string = aString.length() > 64 ? aString.substring(0, 64) : aString;
        return STRING_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, STRING_NAME_HINT_PREFIX.length() > 0, aString);
    }

    protected String getTypeNameHint(@NonNull Type aType) {
        if (aType instanceof CollectionType) {
            if (aType instanceof OrderedSetType) {
                return ORDERED_SET_NAME_HINT_PREFIX;
            }
            if (aType instanceof SetType) {
                return SET_NAME_HINT_PREFIX;
            }
            if (aType instanceof SequenceType) {
                return SEQUENCE_NAME_HINT_PREFIX;
            }
            if (aType instanceof BagType) {
                return BAG_NAME_HINT_PREFIX;
            }
            return COLLECTION_NAME_HINT_PREFIX;
        }
        @NonNull String string = aType.toString();
        return TYPE_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, TYPE_NAME_HINT_PREFIX.length() > 0, aType);
    }

    protected String getVariableDeclarationNameHint(@NonNull VariableDeclaration aVariableDeclaration) {
        String string = (String)ClassUtil.nonNullModel((Object)aVariableDeclaration.getName());
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, aVariableDeclaration);
    }

    public @NonNull String reserveName(@NonNull String name, @Nullable Object anObject) {
        return this.context.getSymbolName(anObject, name);
    }

    public class Context {
        private final @Nullable Context context;
        private final @NonNull Map<String, Object> name2object;
        private final @NonNull Map<Object, String> object2name;
        private Map<String, Integer> name2counter;

        public Context() {
            this.context = null;
            this.name2object = new HashMap<String, Object>();
            this.object2name = new HashMap<Object, String>();
            this.name2counter = null;
        }

        public Context(Context context) {
            this.context = context;
            this.name2object = new HashMap<String, Object>(context.name2object);
            this.object2name = new HashMap<Object, String>(context.object2name);
            this.name2counter = context.name2counter != null ? new HashMap<String, Integer>(context.name2counter) : null;
        }

        public @NonNull Context createNestedContext() {
            return new Context(this);
        }

        public @NonNull Context getContext() {
            return (Context)ClassUtil.nonNullState((Object)this.context);
        }

        protected @NonNull String getGlobalUniqueName(@Nullable Object anObject, String ... nameHints) {
            if (this.context != null) {
                return this.context.getGlobalUniqueName(anObject, nameHints);
            }
            return this.getUniqueName(anObject, nameHints);
        }

        public @NonNull String getSymbolName(@Nullable Object anObject, String ... nameHints) {
            if (nameHints != null && nameHints.length > 0 && nameHints[0] != null) {
                return this.getUniqueName(anObject, nameHints);
            }
            return this.getUniqueName(anObject, anObject != null ? NameManager.this.getNameHint(anObject) : null);
        }

        public @NonNull String getUniqueName(@Nullable Object anObject, String ... nameHints) {
            Integer counter;
            int count;
            String knownName;
            if (anObject instanceof RealValue && !(anObject instanceof InvalidValue)) {
                anObject = ((RealValue)anObject).asNumber();
            }
            if (anObject != null && (knownName = this.object2name.get(anObject)) != null) {
                return knownName;
            }
            String lastResort = null;
            if (nameHints != null) {
                String[] stringArray = nameHints;
                int n = nameHints.length;
                int n2 = 0;
                while (n2 < n) {
                    String validHint;
                    String nameHint = stringArray[n2];
                    if (nameHint != null && (!reservedJavaNames.contains(validHint = NameManager.getValidJavaIdentifier(nameHint, false, anObject)) || anObject instanceof CGValuedElement && this.isNative((CGValuedElement)anObject))) {
                        if (anObject != null) {
                            Object oldElement = this.name2object.get(validHint);
                            if (oldElement == anObject) {
                                return validHint;
                            }
                            if (oldElement == null && !this.name2object.containsKey(validHint)) {
                                this.install(validHint, anObject);
                                return validHint;
                            }
                        } else if (!this.name2object.containsKey(validHint)) {
                            this.install(validHint, anObject);
                            return validHint;
                        }
                        if (lastResort == null) {
                            lastResort = validHint;
                        }
                    }
                    ++n2;
                }
            }
            if (lastResort == null) {
                lastResort = NameManager.DEFAULT_NAME_PREFIX;
            }
            if (this.name2counter == null) {
                this.name2counter = new HashMap<String, Integer>();
            }
            int n = count = (counter = this.name2counter.get(lastResort)) != null ? counter : 0;
            while (true) {
                String attempt;
                if (!this.name2object.containsKey(attempt = String.valueOf(lastResort) + "_" + Integer.toString(count))) {
                    this.install(attempt, anObject);
                    this.name2counter.put(lastResort, ++count);
                    return attempt;
                }
                ++count;
            }
        }

        private void install(@NonNull String name, @Nullable Object anObject) {
            assert (!(anObject instanceof RealValue) || anObject instanceof InvalidValue);
            this.name2object.put(name, anObject);
            if (anObject != null) {
                this.object2name.put(anObject, name);
            }
        }

        private boolean isNative(@NonNull CGValuedElement cgElement) {
            PackageId packageId;
            TypeId asTypeId = cgElement.getASTypeId();
            return asTypeId instanceof NestedTypeId && (packageId = ((NestedTypeId)asTypeId).getParent()) instanceof RootPackageId && ((RootPackageId)packageId).getName().contains("://");
        }
    }
}

