/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.storage.StorageUtil;

public class LazyProfileRegistryComponent
implements IAgentServiceFactory {
    public static final String PROP_LAZY_PROFILE_REGISTRY = "oomph.p2.lazy.profile.registry";

    public Object createService(IProvisioningAgent agent) {
        boolean isLazySupported;
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        File directory = LazyProfileRegistry.getDefaultRegistryDirectory((IAgentLocation)location);
        SimpleProfileRegistry registry = null;
        boolean bl = isLazySupported = !"false".equals(PropertiesUtil.getProperty((String)PROP_LAZY_PROFILE_REGISTRY));
        if (isLazySupported) {
            try {
                registry = new LazyProfileRegistry(agent, directory, OsgiHelper.canWrite(directory));
            }
            catch (Throwable ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
        }
        if (registry == null) {
            registry = new SimpleProfileRegistry(agent, directory);
        }
        registry.setEventBus((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME));
        return registry;
    }

    static class OsgiHelper {
        OsgiHelper() {
        }

        public static boolean canWrite(File installDir) {
            try {
                return StorageUtil.canWrite((File)installDir);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!installDir.canWrite() || !installDir.isDirectory()) {
                    return false;
                }
                File fileTest = null;
                try {
                    try {
                        fileTest = File.createTempFile("test", ".dll", installDir);
                    }
                    catch (IOException iOException) {
                        if (fileTest != null) {
                            fileTest.delete();
                        }
                        return false;
                    }
                }
                finally {
                    if (fileTest != null) {
                        fileTest.delete();
                    }
                }
                return true;
            }
        }
    }
}

