/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ComponentPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ErrorComponentPart
extends ComponentPart {
    public ErrorComponentPart(TabFolderPart parent) {
        super(parent, ErrorComponentPart.createErrorComponentPartModel(), null);
        this.createPartControl(parent.getControl());
    }

    private static IComponentModel createErrorComponentPartModel() {
        IComponentModel componentModel = new IComponentModel(){

            @Override
            public void dispose() {
            }

            @Override
            public String getTabTitle() {
                return "Invalid tab";
            }

            @Override
            public Image getTabIcon() {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }

            public Image getComponentIcon() {
                return Display.getDefault().getSystemImage(1);
            }

            @Override
            public Object getRawModel() {
                return null;
            }

            @Override
            public Composite createPartControl(Composite parent) {
                Composite tabComposite = new Composite(parent, 0);
                tabComposite.setLayout((Layout)new GridLayout(2, false));
                Image componentIcon = this.getComponentIcon();
                if (componentIcon != null) {
                    Label errorImageLabel = new Label(tabComposite, 0);
                    errorImageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                    errorImageLabel.setImage(componentIcon);
                }
                Label label = new Label(tabComposite, 0);
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label.setText("Invalid tab");
                return tabComposite;
            }
        };
        return componentModel;
    }
}

