/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DefaultDiagramPasteCommand
extends AbstractTransactionalCommand {
    private static final int DEFAULT_AVOID_SUPERPOSITION_Y = 10;
    private static final int DEFAULT_AVOID_SUPERPOSITION_X = 10;
    protected View container = null;
    protected List<EObject> semanticList = new ArrayList<EObject>();
    protected List<EObject> viewList = new ArrayList<EObject>();
    protected ICommand editCommand;
    private CompoundCommand allDropCommand;
    private GraphicalEditPart targetEditPart;
    private List<EObject> objectToDrop;

    public DefaultDiagramPasteCommand(TransactionalEditingDomain editingDomain, String label, PapyrusClipboard<Object> papyrusClipboard, GraphicalEditPart targetEditPart) {
        super(editingDomain, label, null);
        this.container = (View)targetEditPart.getModel();
        this.targetEditPart = targetEditPart;
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        List rootElementInClipboard = EcoreUtil.filterDescendants(this.filterEObject((Collection<Object>)papyrusClipboard));
        copier.copyAll((Collection)rootElementInClipboard);
        copier.copyReferences();
        this.viewList.addAll(EcoreUtil.filterDescendants((Collection)copier.values()));
        for (Object eObject : rootElementInClipboard) {
            if (eObject instanceof View) continue;
            this.viewList.remove(copier.get(eObject));
            this.semanticList.add((EObject)copier.get(eObject));
        }
        Map<Object, EObject> transtypeCopier = this.transtypeCopier(copier);
        papyrusClipboard.addAllInternalToTargetCopy(transtypeCopier);
        List semanticRootList = EcoreUtil.filterDescendants(this.semanticList);
        MoveRequest moveRequest = new MoveRequest(this.container.getElement(), semanticRootList);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.container.getElement());
        if (provider != null) {
            this.editCommand = provider.getEditCommand((IEditCommandRequest)moveRequest);
        }
        if (!papyrusClipboard.getContainerType().equals(targetEditPart.getNotationView().getDiagram().getType()) || this.viewList.isEmpty()) {
            this.objectToDrop = semanticRootList;
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.editCommand.execute(progressMonitor, info);
        if (this.objectToDrop != null) {
            this.constructDropRequest(this.targetEditPart, this.objectToDrop);
            if (this.allDropCommand != null && !this.allDropCommand.isEmpty()) {
                this.allDropCommand.execute();
            }
        } else if (this.viewList != null && !this.viewList.isEmpty()) {
            this.shiftLayoutList(this.container, this.viewList);
        }
        return this.editCommand.getCommandResult();
    }

    protected void constructDropRequest(GraphicalEditPart targetEditPart, List<EObject> objectToDrop) {
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        if (this.container instanceof Diagram) {
            Point cursorPosition = this.getCursorPosition(targetEditPart);
            this.allDropCommand = new CompoundCommand("Drop all semantics elements on diagram");
            for (EObject eObject : objectToDrop) {
                dropObjectsRequest.setObjects(Collections.singletonList(eObject));
                dropObjectsRequest.setLocation(cursorPosition);
                Command command = targetEditPart.getCommand((Request)dropObjectsRequest);
                this.allDropCommand.add(command);
                cursorPosition = this.shiftLayout(cursorPosition);
            }
        } else if (!(this.container instanceof Diagram)) {
            Rectangle bounds = targetEditPart.getFigure().getBounds();
            Point center = bounds.getCenter();
            this.allDropCommand = new CompoundCommand("Drop all semantics elements on a view");
            dropObjectsRequest.setObjects(objectToDrop);
            dropObjectsRequest.setLocation(center);
            Command command = targetEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) {
                command = this.lookForCommandInSubContainer(targetEditPart, objectToDrop);
            }
            this.allDropCommand.add(command);
        }
    }

    protected Command lookForCommandInSubContainer(GraphicalEditPart targetEditPart, List<EObject> objectToDrop) {
        List children = targetEditPart.getChildren();
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        for (Object object : children) {
            if (!(object instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)object;
            Point center = graphicalEditPart.getFigure().getBounds().getCenter();
            dropObjectsRequest.setLocation(center);
            dropObjectsRequest.setObjects(objectToDrop);
            Command command = graphicalEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private void shiftLayoutList(View container, Collection<EObject> values) {
        for (EObject object : values) {
            LayoutConstraint layoutConstraint;
            if (!(object instanceof View)) continue;
            View duplicatedView = (View)object;
            if (object instanceof Shape && (layoutConstraint = ((Shape)object).getLayoutConstraint()) instanceof Bounds) {
                ((Bounds)layoutConstraint).setX(((Bounds)layoutConstraint).getX() + 10);
                ((Bounds)layoutConstraint).setY(((Bounds)layoutConstraint).getY() + 10);
            }
            if (duplicatedView.eContainer() != null || container == null) continue;
            ViewUtil.insertChildView((View)container, (View)duplicatedView, (int)-1, (boolean)true);
        }
    }

    protected Point shiftLayout(Point point) {
        return new Point(point.x + 10, point.y + 10);
    }

    protected Point getCursorPosition(GraphicalEditPart targetEditPart) {
        Display display = Display.getDefault();
        org.eclipse.swt.graphics.Point cursorLocation = display.getCursorLocation();
        EditPartViewer viewer = targetEditPart.getViewer();
        Control control = viewer.getControl();
        org.eclipse.swt.graphics.Point point = control.toControl(cursorLocation);
        FigureCanvas figureCanvas = (FigureCanvas)control;
        Point location = figureCanvas.getViewport().getViewLocation();
        return new Point(point.x + location.x, point.y + location.y);
    }

    protected Collection<EObject> filterEObject(Collection<Object> collection) {
        ArrayList<EObject> eobjectList = new ArrayList<EObject>();
        for (Object object : collection) {
            if (!(object instanceof EObject)) continue;
            eobjectList.add((EObject)object);
        }
        return eobjectList;
    }

    protected Map<Object, EObject> transtypeCopier(EcoreUtil.Copier copier) {
        HashMap<Object, EObject> map = new HashMap<Object, EObject>();
        Set entrySet = copier.entrySet();
        for (Map.Entry entry : entrySet) {
            map.put(entry.getKey(), (EObject)entry.getValue());
        }
        return map;
    }
}

