/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;

public class BorderedScalableImageFigure
extends ScalableImageFigure {
    private RenderedImage lastRenderedImage;

    public BorderedScalableImageFigure(RenderedImage renderedImage, boolean useDefaultImageSize, boolean useOriginalColors, boolean antiAlias) {
        super(renderedImage, useDefaultImageSize, useOriginalColors, antiAlias);
        this.setLayoutManager((LayoutManager)new BorderedLayoutManager());
        this.lastRenderedImage = renderedImage;
    }

    protected void paintFigure(Graphics graphics) {
        if (!this.lastRenderedImage.getSWTImage().isDisposed()) {
            Rectangle parentBounds = this.getParent().getBounds().getCopy();
            IRoundedRectangleFigure roundedCompartmentFigure = this.getMainFigure();
            if (roundedCompartmentFigure != null) {
                this.setBackgroundColor(roundedCompartmentFigure.getBackgroundColor());
                this.setForegroundColor(roundedCompartmentFigure.getForegroundColor());
            } else {
                this.setBackgroundColor(this.getParent().getBackgroundColor());
                this.setForegroundColor(this.getParent().getForegroundColor());
            }
            graphics.setClip(parentBounds);
            super.paintFigure(graphics);
        }
    }

    private IRoundedRectangleFigure getMainFigure() {
        SVGNodePlateFigure svgNodePlate = FigureUtils.findParentFigureInstance((IFigure)this, SVGNodePlateFigure.class);
        return svgNodePlate == null ? null : FigureUtils.findChildFigureInstance((IFigure)svgNodePlate, IRoundedRectangleFigure.class);
    }

    class BorderedLayoutManager
    extends AbstractLayout {
        BorderedLayoutManager() {
        }

        public void layout(IFigure container) {
            ScrollPane scrollPaneFigure = FigureUtils.findParentFigureInstance(container, ScrollPane.class);
            if (scrollPaneFigure instanceof ScrollPane) {
                scrollPaneFigure.setScrollBarVisibility(0);
            }
            if (BorderedScalableImageFigure.this.isMaintainAspectRatio() && container.getParent().getChildren().size() == 1) {
                Rectangle scalableCompartmentBounds;
                ScalableCompartmentFigure scalableCompartmentFigure = FigureUtils.findParentFigureInstance(container, ScalableCompartmentFigure.class);
                ScalableImageFigure scalableImage = FigureUtils.findChildFigureInstance(BorderedScalableImageFigure.this.getParent(), ScalableImageFigure.class);
                double ratio = 1.0;
                RenderedImage renderedImage = scalableImage.getRenderedImage();
                if (renderedImage instanceof SVGImage) {
                    SVGImage img = (SVGImage)renderedImage;
                    PrecisionDimension svgDimension = this.getSvgDimension(img.getDocument());
                    ratio = svgDimension.preciseWidth() / svgDimension.preciseHeight();
                }
                scalableCompartmentBounds = scalableCompartmentFigure != null ? (scalableCompartmentBounds = scalableCompartmentFigure.getBounds()) : container.getBounds();
                Point center = new Point(scalableCompartmentBounds.x + scalableCompartmentBounds.width / 2, scalableCompartmentBounds.y + scalableCompartmentBounds.height / 2);
                int width = 0;
                int height = 0;
                int y = 0;
                int x = 0;
                if (scalableCompartmentBounds.width > scalableCompartmentBounds.height) {
                    if ((double)scalableCompartmentBounds.width > (double)scalableCompartmentBounds.height * ratio) {
                        width = (int)((double)scalableCompartmentBounds.height * ratio);
                        height = scalableCompartmentBounds.height;
                    } else {
                        width = scalableCompartmentBounds.width;
                        height = (int)((double)scalableCompartmentBounds.width / ratio);
                    }
                } else if ((double)scalableCompartmentBounds.height < (double)scalableCompartmentBounds.width / ratio) {
                    width = (int)((double)scalableCompartmentBounds.height * ratio);
                    height = scalableCompartmentBounds.height;
                } else {
                    width = scalableCompartmentBounds.width;
                    height = (int)((double)scalableCompartmentBounds.width / ratio);
                }
                y = center.y - height / 2;
                x = center.x - width / 2;
                container.setBounds(new Rectangle(x, y, width, height));
            } else if (scrollPaneFigure instanceof ScrollPane) {
                container.setBounds(scrollPaneFigure.getBounds());
            }
        }

        private double getValueOf(SVGAnimatedLength length) {
            if (length == null) {
                return 0.0;
            }
            SVGLength base = length.getBaseVal();
            if (base == null) {
                return 0.0;
            }
            return base.getValue();
        }

        private PrecisionDimension getSvgDimension(Document document) {
            SVGSVGElement svgElement;
            double svgWidth = 0.0;
            double svgHeight = 0.0;
            if (document.getDocumentElement() instanceof SVGSVGElement && (svgElement = (SVGSVGElement)document.getDocumentElement()) != null) {
                svgWidth = this.getValueOf(svgElement.getWidth());
                svgHeight = this.getValueOf(svgElement.getHeight());
            }
            return new PrecisionDimension(svgWidth, svgHeight);
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return null;
        }
    }
}

