/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.object;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui.EditorHyperLinkEditorShell;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkEditor
extends HyperLinkObject {
    public void openLink() {
        EObject context = EMFHelper.getEObject((Object)this.getObject());
        if (context != null) {
            try {
                IPageManager pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)context);
                Object objectToOpen = this.getObject();
                if (pageManager.isOpen(objectToOpen)) {
                    pageManager.selectPage(objectToOpen);
                } else {
                    pageManager.openPage(objectToOpen);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    public void executeEditMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject amodel) {
        IPageIconsRegistry editorRegistry;
        try {
            editorRegistry = (IPageIconsRegistry)ServiceUtilsForEObject.getInstance().getService(IPageIconsRegistry.class, (Object)amodel);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        EditorHyperLinkEditorShell editor = new EditorHyperLinkEditorShell(parentShell, editorRegistry, amodel);
        editor.setHyperLinkEditor(this);
        editor.open();
        if (editor.getHyperLinkEditor() != null) {
            int index = list.indexOf((Object)this);
            list.remove((Object)this);
            list.add(index, editor.getHyperLinkEditor());
        }
    }

    public boolean needsOpenCommand() {
        return false;
    }
}

