/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.gmf.runtime.common.ui.preferences.ComboFieldEditor;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.UnitsConverterUtils;
import org.eclipse.papyrus.infra.gmfdiag.preferences.jface.preference.ColorFieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RulersAndGridGroup
extends AbstractGroup {
    private int oldUnits = -1;
    private String RULER_GROUP_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerGroup_label;
    private String SHOW_RULERS_LABEL = DiagramUIMessages.GridRulerPreferencePage_showRulers_label;
    private String RULER_UNITS_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_label;
    private String RULER_UNITS_IN_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_inch_label;
    private String RULER_UNITS_CM_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_cm_label;
    private String RULER_UNITS_PIXEL_LABEL = DiagramUIMessages.GridRulerPreferencePage_rulerUnits_pixel_label;
    private String GRID_GROUP_LABEL = DiagramUIMessages.GridRulerPreferencePage_gridGroup_label;
    private String SHOW_GRID_LABEL = DiagramUIMessages.GridRulerPreferencePage_showGrid_label;
    private String SNAP_TO_GRID_LABEL = DiagramUIMessages.GridRulerPreferencePage_snapToGrid_label;
    private String SNAP_TO_GEOMETRY_LABEL = DiagramUIMessages.GridRulerPreferencePage_snapToGeometry_label;
    private String GRID_SPACING_LABEL_INCHES = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_inches;
    private String GRID_SPACING_LABEL_CM = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_cm;
    private String GRID_SPACING_LABEL_PIXELS = DiagramUIMessages.GridRulerPreferencePage_gridSpacing_label_pixels;
    private BooleanFieldEditor showRulers = null;
    private ComboFieldEditor rulerUnits;
    private BooleanFieldEditor showGrid = null;
    private BooleanFieldEditor snapToGrid = null;
    private BooleanFieldEditor snapToGeometry = null;
    private DoubleFieldEditor gridSpacing = null;
    private BooleanFieldEditor gridInFront = null;
    private ComboFieldEditor gridStyle = null;
    private Composite dblGroup = null;
    private ColorFieldEditor gridColorEditor = null;

    protected String getPreferenceConstant(int preferenceType) {
        return PreferencesConstantsHelper.getElementConstant((String)this.getKey(), (int)preferenceType);
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)25), 2);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)23), false);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)24), false);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)26), false);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)27), false);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)31), 6);
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)30), false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferencesConstantsHelper.getPapyrusEditorConstant((int)28), (RGB)new RGB(250, 0, 0));
        int rgbValue = 50;
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferencesConstantsHelper.getPapyrusEditorConstant((int)28), (RGB)new RGB(50, 50, 50));
        store.setDefault(PreferencesConstantsHelper.getPapyrusEditorConstant((int)29), 20);
    }

    public RulersAndGridGroup(Composite parent, String key, DialogPage dialogPage) {
        super(parent, key, dialogPage);
        this.createContents(parent);
    }

    public void createContents(Composite parent) {
        this.addRulerFields(parent);
        this.addGridFields(parent);
    }

    private void addRulerFields(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.RULER_GROUP_LABEL);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.showRulers = new BooleanFieldEditor(this.getPreferenceConstant(23), this.SHOW_RULERS_LABEL, (Composite)group);
        this.addFieldEditor((FieldEditor)this.showRulers);
        this.rulerUnits = new ComboFieldEditor(this.getPreferenceConstant(25), this.RULER_UNITS_LABEL, (Composite)group, 2, false, 0, 0, true);
        this.addFieldEditor((FieldEditor)this.rulerUnits);
        this.rulerUnits.addIndexedItemToCombo(this.RULER_UNITS_IN_LABEL, 0);
        this.rulerUnits.addIndexedItemToCombo(this.RULER_UNITS_CM_LABEL, 1);
        this.rulerUnits.addIndexedItemToCombo(this.RULER_UNITS_PIXEL_LABEL, 2);
        Combo rulerUnitsCombo = this.rulerUnits.getComboControl();
        rulerUnitsCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RulersAndGridGroup.this.updateUnits();
            }
        });
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
    }

    private void addGridFields(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.GRID_GROUP_LABEL);
        GridLayout gridLayout = new GridLayout(2, true);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.showGrid = new BooleanFieldEditor(this.getPreferenceConstant(24), this.SHOW_GRID_LABEL, (Composite)group);
        this.addFieldEditor((FieldEditor)this.showGrid);
        this.snapToGrid = new BooleanFieldEditor(this.getPreferenceConstant(26), this.SNAP_TO_GRID_LABEL, (Composite)group);
        this.addFieldEditor((FieldEditor)this.snapToGrid);
        this.snapToGeometry = new BooleanFieldEditor(this.getPreferenceConstant(27), this.SNAP_TO_GEOMETRY_LABEL, (Composite)group);
        this.addFieldEditor((FieldEditor)this.snapToGeometry);
        this.gridInFront = new BooleanFieldEditor(this.getPreferenceConstant(30), Messages.RulersAndGridGroup_GridInFront, (Composite)group);
        this.addFieldEditor((FieldEditor)this.gridInFront);
        this.addGridStyle((Composite)group);
        this.addGridColor((Composite)group);
        this.addGridSpacing((Composite)group);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
    }

    private void addGridStyle(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.gridStyle = new ComboFieldEditor(this.getPreferenceConstant(31), Messages.RulersAndGridGroup_GridStyle, composite, 2, false, 0, 0, true);
        this.gridStyle.addIndexedItemToCombo("Solid", 1);
        this.gridStyle.addIndexedItemToCombo("Dash", 2);
        this.gridStyle.addIndexedItemToCombo("Dot", 3);
        this.gridStyle.addIndexedItemToCombo("Dash Dot", 4);
        this.gridStyle.addIndexedItemToCombo("Dash Dot Dot", 5);
        this.gridStyle.addIndexedItemToCombo("Custom", 6);
        this.addFieldEditor((FieldEditor)this.gridStyle);
    }

    private void addGridColor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(Messages.RulersAndGridGroup_GridColor);
        this.gridColorEditor = new ColorFieldEditor(this.getPreferenceConstant(28), DiagramUIPropertiesImages.get((String)"icons/line_color.gif"), composite);
        this.addFieldEditor(this.gridColorEditor);
        composite.setLayout((Layout)new GridLayout(2, true));
    }

    private void addGridSpacing(Composite parent) {
        this.dblGroup = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.gridSpacing = new DoubleFieldEditor(this.getPreferenceConstant(29), this.GRID_SPACING_LABEL_INCHES, this.dblGroup);
        this.gridSpacing.setTextLimit(10);
        this.addFieldEditor((FieldEditor)this.gridSpacing);
        this.updateUnits();
        this.dblGroup.setLayoutData((Object)gridData);
        this.dblGroup.setLayout((Layout)gridLayout);
    }

    protected void initHelp() {
    }

    private Double forceDouble(Number number) {
        if (!(number instanceof Double)) {
            return new Double(number.doubleValue());
        }
        return (Double)number;
    }

    private void updateUnits() {
        int units = this.getUnits();
        switch (units) {
            case 0: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_INCHES);
                break;
            }
            case 1: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_CM);
                break;
            }
            case 2: {
                this.gridSpacing.setLabelText(this.GRID_SPACING_LABEL_PIXELS);
            }
        }
        this.gridSpacing.setStringValue(UnitsConverterUtils.convertUnits((int)this.oldUnits, (int)units, (String)this.gridSpacing.getStringValue()));
        this.oldUnits = units;
        this.dblGroup.layout();
    }

    private int getUnits() {
        int units = this.rulerUnits.getComboControl().getSelectionIndex();
        if (units == -1) {
            this.oldUnits = units = 1;
        }
        return units;
    }

    private double convertToBase(double number) {
        double returnValue = 0.0;
        switch (this.getUnits()) {
            case 0: {
                returnValue = number;
                break;
            }
            case 1: {
                returnValue = number / 2.54;
                break;
            }
            case 2: {
                returnValue = number / (double)this.getDisplay().getDPI().x;
            }
        }
        return returnValue;
    }

    private class DoubleFieldEditor
    extends StringFieldEditor {
        private double minValidValue;
        private double maxValidValue;

        public DoubleFieldEditor(String pref, String label, Composite parent) {
            super(pref, label, parent);
            this.minValidValue = 0.009;
            this.maxValidValue = 99.999;
        }

        protected boolean doCheckState() {
            block6: {
                Number parsedNumber;
                ParsePosition parsePosition;
                Text text;
                block5: {
                    text = this.getTextControl();
                    if (text == null) {
                        return false;
                    }
                    try {
                        NumberFormat numberFormatter = NumberFormat.getInstance();
                        parsePosition = new ParsePosition(0);
                        parsedNumber = numberFormatter.parse(text.getText(), parsePosition);
                        if (parsedNumber != null) break block5;
                        this.showErrorMessage();
                        return false;
                    }
                    catch (NumberFormatException e1) {
                        this.showErrorMessage();
                        return false;
                    }
                }
                Double pageHeight = RulersAndGridGroup.this.forceDouble(parsedNumber);
                double number = pageHeight;
                number = RulersAndGridGroup.this.convertToBase(number);
                if (!(number >= this.minValidValue) || !(number <= this.maxValidValue) || parsePosition.getIndex() != text.getText().length()) break block6;
                this.clearErrorMessage();
                return true;
            }
            this.showErrorMessage();
            return false;
        }

        protected void doLoadDefault() {
            Text text = this.getTextControl();
            if (text != null) {
                double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
                NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                text.setText(numberFormatter.format(value));
            }
            this.valueChanged();
        }

        protected void doLoad() {
            Text text = this.getTextControl();
            if (text != null) {
                double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
                NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                text.setText(numberFormatter.format(value));
            }
        }

        protected void doStore() {
            NumberFormat numberFormatter = NumberFormat.getInstance();
            try {
                Double gridWidth = RulersAndGridGroup.this.forceDouble(numberFormatter.parse(this.getTextControl().getText()));
                this.getPreferenceStore().setValue(this.getPreferenceName(), gridWidth.doubleValue());
            }
            catch (ParseException e) {
                this.showErrorMessage();
            }
        }
    }
}

