/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.menu.PapyrusBodyPopupMenuAction;
import org.eclipse.papyrus.infra.nattable.menu.PapyrusHeaderPopupMenuAction;

public class TablePopupMenuConfiguration
extends AbstractUiBindingConfiguration {
    protected final NatTable natTable;
    private PapyrusBodyPopupMenuAction bodyPopupMenuAction;
    private PapyrusHeaderPopupMenuAction rowHeaderPopupMenuAction;
    private PapyrusHeaderPopupMenuAction columnHeaderMenuAction;

    public TablePopupMenuConfiguration(NatTable natTable) {
        this.natTable = natTable;
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        this.registerBodyPopupMenu(uiBindingRegistry);
        this.registerColumnHeaderPopupMenu(uiBindingRegistry);
        this.registerRowHeaderPopupMenu(uiBindingRegistry);
    }

    protected void registerBodyPopupMenu(UiBindingRegistry uiBindingRegistry) {
        this.bodyPopupMenuAction = new PapyrusBodyPopupMenuAction("org.eclipse.papyrus.infra.nattable.widget.menu", this.natTable);
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)this.bodyPopupMenuAction);
    }

    protected void registerRowHeaderPopupMenu(UiBindingRegistry uiBindingRegistry) {
        this.rowHeaderPopupMenuAction = new PapyrusHeaderPopupMenuAction("org.eclipse.papyrus.infra.nattable.widget.header.rows.menu", this.natTable);
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "ROW_HEADER", 3), (IMouseAction)this.rowHeaderPopupMenuAction);
    }

    protected void registerColumnHeaderPopupMenu(UiBindingRegistry uiBindingRegistry) {
        this.columnHeaderMenuAction = new PapyrusHeaderPopupMenuAction("org.eclipse.papyrus.infra.nattable.header.columns.menu", this.natTable);
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_HEADER", 3), (IMouseAction)this.columnHeaderMenuAction);
    }

    public void dispose() {
        if (this.bodyPopupMenuAction != null) {
            this.bodyPopupMenuAction.dispose();
        }
        if (this.rowHeaderPopupMenuAction != null) {
            this.rowHeaderPopupMenuAction.dispose();
        }
        if (this.columnHeaderMenuAction != null) {
            this.columnHeaderMenuAction.dispose();
        }
    }
}

