/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;

public class OneFileUtils {
    public static boolean diExists(String fileName, IContainer parent) {
        return OneFileUtils.getDi(fileName, parent) != null;
    }

    public static IFile getDi(String fileName, IContainer parent) {
        IFile file;
        if (parent == null || parent.getType() == 8) {
            return null;
        }
        String substring = fileName;
        if (fileName.indexOf(46) > 0) {
            substring = fileName.substring(0, fileName.lastIndexOf(46));
        }
        if ((file = parent.getFile((IPath)new Path(String.valueOf(substring) + "." + "di"))).exists()) {
            return file;
        }
        return null;
    }

    public static boolean hasChildren(Object element) {
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            try {
                return container.members().length > 0;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (element instanceof IPapyrusFile) {
            IPapyrusFile iPapyrusFile = (IPapyrusFile)element;
            return iPapyrusFile.getMainFile() != null && iPapyrusFile.getAssociatedResources().length > 1;
        }
        return false;
    }

    public static boolean isVisible(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return !OneFileUtils.diExists(file.getName(), file.getParent());
        }
        return true;
    }

    public static boolean isDi(IResource fileName) {
        return PapyrusModelHelper.getPapyrusModelFactory().isDi(fileName);
    }

    public static String withoutFileExtension(IResource res) {
        if (res.getFileExtension() != null && res.getFileExtension().length() > 0) {
            return res.getName().substring(0, res.getName().lastIndexOf(46));
        }
        return res.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsModelFiles(IResource resource) {
        if (!(resource instanceof IContainer)) return false;
        IContainer container = (IContainer)resource;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource m = iResourceArray[n2];
                if (OneFileUtils.isDi(m)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static IFile[] getAssociatedFiles(IPapyrusFile papyrusFile) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = papyrusFile.getAssociatedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                files.add((IFile)res);
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }
}

