/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.locators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.PortFigure;

public abstract class BasePortChildLocator
implements IBorderItemLocator {
    protected final PortFigure myPort;

    public BasePortChildLocator(PortFigure port) {
        this.myPort = port;
    }

    protected int getPortSide() {
        Rectangle parent = this.getParentBounds();
        Rectangle port = this.myPort.getBounds();
        int yPortLocation = port.y + port.height / 2;
        int xPortLocation = port.x + port.width / 2;
        int side = 0;
        if (yPortLocation == parent.y) {
            side |= 1;
        }
        if (yPortLocation == parent.y + parent.height) {
            side |= 4;
        }
        if (xPortLocation == parent.x) {
            side |= 8;
        }
        if (xPortLocation == parent.x + parent.width) {
            side |= 0x10;
        }
        return side == 0 ? 4 : side;
    }

    private Rectangle getParentBounds() {
        IFigure parent = this.myPort.getParent();
        while (!(parent instanceof SelectableBorderedNodeFigure) && parent != null) {
            parent = parent.getParent();
        }
        return ((SelectableBorderedNodeFigure)parent).getMainFigure().getBounds();
    }

    public void setConstraint(Rectangle constraint) {
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return null;
    }

    public int getCurrentSideOfParent() {
        return 0;
    }
}

