/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.custom.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.deployment.custom.edit.command.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.deployment.custom.edit.helpers.DeploymentLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.deployment.custom.edit.helpers.MultiDependencyHelper;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.deployment.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)DeploymentLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualId = new HashSet<String>();
        droppableElementsVisualId.add("Comment_Shape_CN");
        droppableElementsVisualId.add("Constraint_Shape_CN");
        droppableElementsVisualId.add("Dependency_Shape");
        droppableElementsVisualId.add("Model_Shape");
        droppableElementsVisualId.add("Artifact_Shape");
        droppableElementsVisualId.add("Comment_Shape");
        droppableElementsVisualId.add("Constraint_Shape");
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block55: {
            block53: {
                if (linkVISUALID == null) break block53;
                switch (linkVISUALID) {
                    case "Manifestation_Edge": {
                        return this.dropManifestation(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Deployment_Edge": {
                        return this.dropDependencyNode(dropRequest, semanticElement, linkVISUALID);
                    }
                }
            }
            if (nodeVISUALID == null) break block55;
            switch (nodeVISUALID) {
                case "Dependency_Shape": {
                    return this.dropDependencyNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Model_Shape": 
                case "Package_Shape": 
                case "Node_Shape": 
                case "Device_Shape": 
                case "Artifact_Shape": 
                case "ExecutionEnvironment_Shape": {
                    return this.dropTopLevelNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
                }
                case "Package_Shape_CN": 
                case "Device_Shape_CN": 
                case "Model_Shape_CN": 
                case "ExecutionEnvironment_Shape_CN": 
                case "Artifact_Shape_CN": 
                case "Node_Shape_CN": {
                    return this.dropChildNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
                }
                case "Comment_Shape": 
                case "Comment_Shape_CN": {
                    return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Constraint_Shape": 
                case "Constraint_Shape_CN": {
                    return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
                }
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropManifestation(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = DeploymentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = DeploymentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Manifestation"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        if ("Constraint_Shape".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        if ("Constraint_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape_CN, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        if ("Comment_Shape".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        if ("Comment_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape_CN, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropDependencyNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID) {
        Collection<?> sources = DeploymentLinkMappingHelper.getInstance().getSource(semanticElement);
        Collection<?> targets = DeploymentLinkMappingHelper.getInstance().getTarget(semanticElement);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Dependency"), source, target, "Dependency_Edge", dropRequest.getLocation(), semanticElement));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain());
            return dependencyHelper.dropMutliDependency((Dependency)semanticElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = DeploymentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = DeploymentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Dependency"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropProperty(DropObjectsRequest dropRequest, Property droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        Point location = dropRequest.getLocation().getCopy();
        if (!(droppedElement instanceof Port)) {
            Type type;
            if (graphicalParentObject instanceof Classifier && ((Classifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement && (type = ((ConnectableElement)graphicalParentObject).getType()) != null && type instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTopLevelNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropChildNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
    }

    protected CompoundCommand getDropAffixedNodeInCompartmentCommand(String nodeVISUALID, Point location, EObject droppedObject) {
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getModel());
        cc.add((Command)new ICommandProxy((ICommand)createCommand));
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        return cc;
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrag = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrag = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrag.booleanValue()) {
            return null;
        }
        return super.getDragCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrop = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrop = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrop.booleanValue()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return super.getDropCommand(request);
    }

    protected boolean isSpecificDropActionExpected(GraphicalEditPart graphicalParent, EObject droppedObject) {
        boolean isSpecificDropActionExpected = false;
        EObject graphicalParentObject = graphicalParent.resolveSemanticElement();
        if (graphicalParentObject != null) {
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof TypedElement) {
                if (droppedObject instanceof Type) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof CollaborationUse && droppedObject instanceof Collaboration) {
                isSpecificDropActionExpected = true;
            }
        }
        return isSpecificDropActionExpected;
    }
}

