/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class UML {
    private final Set<EClass> relationshipLikeUMLMetaclasses = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[]{UMLPackage.Literals.RELATIONSHIP, UMLPackage.Literals.GENERALIZATION_SET, UMLPackage.Literals.CONNECTOR, UMLPackage.Literals.ACTIVITY_EDGE, UMLPackage.Literals.TRANSITION, UMLPackage.Literals.MESSAGE}));

    protected Profile _getProfile(Profile element) {
        return element;
    }

    protected Profile _getProfile(NamedElement element) {
        EList _allOwningPackages = element.allOwningPackages();
        Iterable _filter = Iterables.filter((Iterable)_allOwningPackages, Profile.class);
        return (Profile)IterableExtensions.head((Iterable)_filter);
    }

    protected Profile _getProfile(ImpliedExtension umlExtension) {
        Stereotype _stereotype = umlExtension.getStereotype();
        return _stereotype.getProfile();
    }

    protected Profile _getRootProfile(Profile element) {
        Profile _elvis = null;
        Namespace _namespace = element.getNamespace();
        Profile _rootProfile = null;
        if (_namespace != null) {
            _rootProfile = this.getRootProfile((NamedElement)_namespace);
        }
        _elvis = _rootProfile != null ? _rootProfile : element;
        return _elvis;
    }

    protected Profile _getRootProfile(NamedElement element) {
        EList _allOwningPackages = element.allOwningPackages();
        Iterable _filter = Iterables.filter((Iterable)_allOwningPackages, Profile.class);
        return (Profile)IterableExtensions.last((Iterable)_filter);
    }

    public Iterable<ImpliedExtension> getAllExtensions(Package package_) {
        EList _ownedTypes = package_.getOwnedTypes();
        Iterable _filter = Iterables.filter((Iterable)_ownedTypes, Stereotype.class);
        Functions.Function1<Stereotype, Iterable<ImpliedExtension>> _function = new Functions.Function1<Stereotype, Iterable<ImpliedExtension>>(){

            public Iterable<ImpliedExtension> apply(Stereotype it) {
                return UML.this.impliedExtensions(it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        EList _nestedPackages = package_.getNestedPackages();
        Functions.Function1<Package, Iterable<ImpliedExtension>> _function_1 = new Functions.Function1<Package, Iterable<ImpliedExtension>>(){

            public Iterable<ImpliedExtension> apply(Package it) {
                return UML.this.getAllExtensions(it);
            }
        };
        List _map_1 = ListExtensions.map((List)_nestedPackages, (Functions.Function1)_function_1);
        Iterable _flatten_1 = Iterables.concat((Iterable)_map_1);
        return Iterables.concat((Iterable)_flatten, (Iterable)_flatten_1);
    }

    public Iterable<ImpliedExtension> impliedExtensions(final Stereotype stereotype) {
        EList _allExtendedMetaclasses = stereotype.getAllExtendedMetaclasses();
        Functions.Function1<Class, ImpliedExtension> _function = new Functions.Function1<Class, ImpliedExtension>(){

            public ImpliedExtension apply(Class it) {
                return new ImpliedExtension(stereotype, it);
            }
        };
        return ListExtensions.map((List)_allExtendedMetaclasses, (Functions.Function1)_function);
    }

    public boolean isRelationship(final EClass eClass) {
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                return it.isSuperTypeOf(eClass);
            }
        };
        return IterableExtensions.exists(this.relationshipLikeUMLMetaclasses, (Functions.Function1)_function);
    }

    public Iterable<EReference> getSourceReferences(EClass relationshipClass) {
        boolean _isSuperTypeOf_6;
        boolean _isSuperTypeOf_5;
        boolean _isSuperTypeOf_4;
        boolean _isSuperTypeOf_3;
        boolean _isSuperTypeOf_2;
        boolean _isSuperTypeOf_1;
        boolean _isSuperTypeOf;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (!_matched && (_isSuperTypeOf = UMLPackage.Literals.DIRECTED_RELATIONSHIP.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            EList _eAllReferences = relationshipClass.getEAllReferences();
            Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                public Boolean apply(EReference it) {
                    boolean _subsets;
                    boolean _isChangeable;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _isDerived = it.isDerived();
                    boolean _not = !_isDerived;
                    _and_1 = !_not ? false : (_isChangeable = it.isChangeable());
                    _and = !_and_1 ? false : (_subsets = UML.this.subsets(it, UMLPackage.Literals.DIRECTED_RELATIONSHIP__SOURCE));
                    return _and;
                }
            };
            _switchResult = IterableExtensions.filter((Iterable)_eAllReferences, (Functions.Function1)_function);
        }
        if (!_matched && (_isSuperTypeOf_1 = UMLPackage.Literals.ASSOCIATION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ASSOCIATION__END_TYPE}));
        }
        if (!_matched && (_isSuperTypeOf_2 = UMLPackage.Literals.CONNECTOR.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.CONNECTOR__END}));
        }
        if (!_matched && (_isSuperTypeOf_3 = UMLPackage.Literals.ACTIVITY_EDGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ACTIVITY_EDGE__SOURCE}));
        }
        if (!_matched && (_isSuperTypeOf_4 = UMLPackage.Literals.TRANSITION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.TRANSITION__SOURCE}));
        }
        if (!_matched && (_isSuperTypeOf_5 = UMLPackage.Literals.MESSAGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.MESSAGE__SEND_EVENT}));
        }
        if (!_matched && (_isSuperTypeOf_6 = UMLPackage.Literals.GENERALIZATION_SET.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.GENERALIZATION_SET__GENERALIZATION}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[0]));
        }
        return _switchResult;
    }

    public Iterable<EReference> getTargetReferences(EClass relationshipClass) {
        boolean _isSuperTypeOf_6;
        boolean _isSuperTypeOf_5;
        boolean _isSuperTypeOf_4;
        boolean _isSuperTypeOf_3;
        boolean _isSuperTypeOf_2;
        boolean _isSuperTypeOf_1;
        boolean _isSuperTypeOf;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (!_matched && (_isSuperTypeOf = UMLPackage.Literals.DIRECTED_RELATIONSHIP.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            EList _eAllReferences = relationshipClass.getEAllReferences();
            Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                public Boolean apply(EReference it) {
                    boolean _subsets;
                    boolean _isChangeable;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _isDerived = it.isDerived();
                    boolean _not = !_isDerived;
                    _and_1 = !_not ? false : (_isChangeable = it.isChangeable());
                    _and = !_and_1 ? false : (_subsets = UML.this.subsets(it, UMLPackage.Literals.DIRECTED_RELATIONSHIP__TARGET));
                    return _and;
                }
            };
            _switchResult = IterableExtensions.filter((Iterable)_eAllReferences, (Functions.Function1)_function);
        }
        if (!_matched && (_isSuperTypeOf_1 = UMLPackage.Literals.ASSOCIATION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ASSOCIATION__END_TYPE}));
        }
        if (!_matched && (_isSuperTypeOf_2 = UMLPackage.Literals.CONNECTOR.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.CONNECTOR__END}));
        }
        if (!_matched && (_isSuperTypeOf_3 = UMLPackage.Literals.ACTIVITY_EDGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ACTIVITY_EDGE__TARGET}));
        }
        if (!_matched && (_isSuperTypeOf_4 = UMLPackage.Literals.TRANSITION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.TRANSITION__TARGET}));
        }
        if (!_matched && (_isSuperTypeOf_5 = UMLPackage.Literals.MESSAGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.MESSAGE__RECEIVE_EVENT}));
        }
        if (!_matched && (_isSuperTypeOf_6 = UMLPackage.Literals.GENERALIZATION_SET.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.GENERALIZATION_SET__GENERALIZATION}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[0]));
        }
        return _switchResult;
    }

    public boolean subsets(EReference subset, EReference superset) {
        EAnnotation _eAnnotation = subset.getEAnnotation("subsets");
        EList _references = null;
        if (_eAnnotation != null) {
            _references = _eAnnotation.getReferences();
        }
        boolean _contains = false;
        if (_references != null) {
            _contains = _references.contains((Object)superset);
        }
        return _contains;
    }

    public Profile getProfile(Object element) {
        if (element instanceof Profile) {
            return this._getProfile((Profile)element);
        }
        if (element instanceof NamedElement) {
            return this._getProfile((NamedElement)element);
        }
        if (element instanceof ImpliedExtension) {
            return this._getProfile((ImpliedExtension)element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public Profile getRootProfile(NamedElement element) {
        if (element instanceof Profile) {
            return this._getRootProfile((Profile)element);
        }
        if (element != null) {
            return this._getRootProfile(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

