/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ConnectorReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UMLFactory;

public class ConnectorEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ConnectorReorientCommand(req);
    }

    protected boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ConnectableElement)) {
            return false;
        }
        if (target != null && !(target instanceof ConnectableElement)) {
            return false;
        }
        if (sourceView != null && targetView != null) {
            if (sourceView == targetView) {
                return false;
            }
            if (sourceView.getChildren().contains((Object)targetView) || targetView.getChildren().contains((Object)sourceView)) {
                return false;
            }
            if (sourceView.getElement() instanceof Port && targetView.getElement() instanceof Port && ViewUtil.getContainerView((View)sourceView) == ViewUtil.getContainerView((View)targetView)) {
                return false;
            }
            if (this.getStructureContainers(sourceView).contains(targetView) || this.getStructureContainers(targetView).contains(sourceView)) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        Object umlStrictParameter;
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (noSourceOrTarget && !noSourceAndTarget) {
            if (!(source instanceof ConnectableElement)) {
                return UnexecutableCommand.INSTANCE;
            }
            return IdentityCommand.INSTANCE;
        }
        if (source != null && target != null) {
            StructuredClassifier proposedContainer = this.deduceContainer(req);
            if (proposedContainer == null) {
                return UnexecutableCommand.INSTANCE;
            }
            EObject container = req.getContainer();
            if (container != proposedContainer) {
                req.setContainer((EObject)proposedContainer);
                return new CreateRelationshipCommand(req);
            }
        }
        boolean umlStrict = true;
        if (!req.getParameters().isEmpty() && (umlStrictParameter = req.getParameter("UML_STRICT")) instanceof Boolean) {
            umlStrict = (Boolean)umlStrictParameter;
        }
        boolean canCreate = true;
        if (umlStrict) {
            canCreate = this.canCreate(source, target, RequestParameterUtils.getSourceView((IEditCommandRequest)req), RequestParameterUtils.getTargetView((IEditCommandRequest)req));
        }
        if (!noSourceAndTarget && !canCreate) {
            return UnexecutableCommand.INSTANCE;
        }
        return new CreateRelationshipCommand(req);
    }

    private ConnectableElement getSourceRole(IEditCommandRequest req) {
        ConnectableElement result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof ConnectableElement) {
            result = (ConnectableElement)paramObject;
        }
        return result;
    }

    private ConnectableElement getTargetRole(IEditCommandRequest req) {
        ConnectableElement result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof ConnectableElement) {
            result = (ConnectableElement)paramObject;
        }
        return result;
    }

    private Property getSourcePartWithPort(IEditCommandRequest req) {
        View parentView;
        EObject semanticParent;
        Property result = null;
        if (this.getSourceRole(req) instanceof Port && (semanticParent = (parentView = ViewUtil.getContainerView((View)RequestParameterUtils.getSourceView(req))).getElement()) instanceof Property && !(semanticParent instanceof Port) && !EcoreUtil.isAncestor((EObject)parentView, (EObject)RequestParameterUtils.getTargetView(req))) {
            result = (Property)semanticParent;
        }
        return result;
    }

    private Property getTargetPartWithPort(IEditCommandRequest req) {
        View parentView;
        EObject semanticParent;
        Property result = null;
        if (this.getTargetRole(req) instanceof Port && (semanticParent = (parentView = ViewUtil.getContainerView((View)RequestParameterUtils.getTargetView(req))).getElement()) instanceof Property && !(semanticParent instanceof Port) && !EcoreUtil.isAncestor((EObject)parentView, (EObject)RequestParameterUtils.getSourceView(req))) {
            result = (Property)semanticParent;
        }
        return result;
    }

    @Override
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        final Connector connector = (Connector)req.getElementToConfigure();
        final ConnectableElement sourceRole = this.getSourceRole((IEditCommandRequest)req);
        final ConnectableElement targetRole = this.getTargetRole((IEditCommandRequest)req);
        final Property sourcePartWithPort = this.getSourcePartWithPort((IEditCommandRequest)req);
        final Property targetPartWithPort = this.getTargetPartWithPort((IEditCommandRequest)req);
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (sourceRole != null) {
                    // empty if block
                }
                ConnectorEnd sourceEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                sourceEnd.setRole(sourceRole);
                sourceEnd.setPartWithPort(sourcePartWithPort);
                ConnectorEnd targetEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                targetEnd.setRole(targetRole);
                targetEnd.setPartWithPort(targetPartWithPort);
                connector.getEnds().add((Object)sourceEnd);
                connector.getEnds().add((Object)targetEnd);
                return CommandResult.newOKCommandResult((Object)connector);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    private StructuredClassifier deduceContainer(CreateRelationshipRequest request) {
        return new ConnectorUtils().deduceContainer(RequestParameterUtils.getSourceView((IEditCommandRequest)request), RequestParameterUtils.getTargetView((IEditCommandRequest)request));
    }

    private List<View> getStructureContainers(View view) {
        return new ConnectorUtils().getStructureContainers(view);
    }
}

