/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.common.util.GeneralizationUtil;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ClassifierHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Association> dependents = new ArrayList<Association>();
        if (request.getElementToDestroy() instanceof Classifier) {
            Classifier classifierToDelete = (Classifier)request.getElementToDestroy();
            dependents.addAll((Collection<Association>)classifierToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            dependents.addAll((Collection<Association>)classifierToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            for (Association association : classifierToDelete.getAssociations()) {
                for (Property end : association.getMemberEnds()) {
                    if (end.getType() != classifierToDelete) continue;
                    dependents.add(association);
                }
            }
        }
        if (!dependents.isEmpty()) {
            return request.getDestroyDependentsCommand(dependents);
        }
        return null;
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand gmfCommand = super.getBeforeMoveCommand(request);
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof Property) || movedObject instanceof Port) continue;
            Property movedProperty = (Property)movedObject;
            EReference[] refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort(), UMLPackage.eINSTANCE.getConnectorEnd_Role()};
            Collection referencers = EMFCoreUtil.getReferencers((EObject)movedProperty, (EReference[])refs);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)movedProperty);
            if (provider == null) continue;
            for (ConnectorEnd end : referencers) {
                DestroyElementRequest req = new DestroyElementRequest((EObject)end, false);
                ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)req);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)deleteCommand);
            }
        }
        List<EObject> currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof Property) || movedObject instanceof Port) continue;
            Property movedProperty = (Property)movedObject;
            Association relatedAssociation = movedProperty.getAssociation();
            if (movedProperty.getAssociation() == null || !ElementUtil.hasNature((Element)movedProperty.getAssociation(), "UML_Nature") || movedProperty.eContainer() == request.getTargetContainer() && movedProperty.eContainingFeature() == request.getTargetFeature((EObject)movedProperty) || currentlyRefactoredElements.contains(movedObject) || currentlyRefactoredElements.contains(relatedAssociation)) continue;
            currentlyRefactoredElements.add((EObject)movedObject);
            request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
            if (relatedAssociation.getMemberEnds().size() != 2) continue;
            ICommand refactorCommand = this.getOppositePropertyRefactoringCommand(movedProperty, relatedAssociation, request);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)refactorCommand);
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private ICommand getOppositePropertyRefactoringCommand(Property movedProperty, Association associationToRefactor, MoveRequest request) {
        Association relatedAssociation = movedProperty.getAssociation();
        Property oppositeEnd = (Property)associationToRefactor.getMemberEnds().get(0);
        if (movedProperty == associationToRefactor.getMemberEnds().get(0)) {
            oppositeEnd = (Property)associationToRefactor.getMemberEnds().get(1);
        }
        SetRequest setType = new SetRequest((EObject)oppositeEnd, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)request.getTargetContainer());
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)relatedAssociation);
        if (provider != null) {
            return provider.getEditCommand((IEditCommandRequest)setType);
        }
        return null;
    }

    protected ICommand getAfterMoveCommand(MoveRequest request) {
        ICommand moveCommand = super.getAfterMoveCommand(request);
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (EObject eObject : request.getElementsToMove().keySet()) {
            if (!(eObject instanceof Generalization)) continue;
            viewsToDestroy.addAll(this.getViewsToDestroy((Generalization)eObject));
            viewsToDestroy.addAll(this.getViewsAccordingToGeneralization((Generalization)eObject));
        }
        for (View view : viewsToDestroy) {
            DeleteCommand destroyViewsCommand = new DeleteCommand(request.getEditingDomain(), view);
            moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)destroyViewsCommand);
        }
        return moveCommand;
    }

    private Set<View> getViewsToDestroy(Generalization movedObject) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)movedObject, null)) {
            String containerType;
            String string = containerType = ViewUtil.getViewContainer((EObject)view) != null ? ViewUtil.getViewContainer((EObject)view).getType() : null;
            if (containerType == null) continue;
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }

    protected Set<View> getViewsAccordingToGeneralization(Generalization generalization) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        Classifier general = generalization.getGeneral();
        if (general != null) {
            EList members = general.getMembers();
            for (NamedElement member : members) {
                Iterator viewIt = CrossReferencerUtil.getCrossReferencingViews((EObject)member, null).iterator();
                while (viewIt.hasNext()) {
                    GeneralizationUtil util = new GeneralizationUtil();
                    View view = (View)viewIt.next();
                    if (!util.isConcernedByGeneralizationChanges(generalization, view)) continue;
                    viewsToDestroy.add(view);
                }
            }
        }
        return viewsToDestroy;
    }
}

