/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.property.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.LinkedList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.alf.naming.ALFIDConverter;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.contributions.UMLPropertyEditorPropertyUtil;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.internal.UmlPropertyActivator;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BooleanLiterals;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BooleanValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.IntValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.ModifierSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.NoValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.NullValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.PropertyRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.RealValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.StringValue;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.TypeRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.Value;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.util.UmlPropertySwitch;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.MultiplicityXTextParserUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.EcoreUtil2;

public class PropertyXtextDirectEditorConfiguration
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    public Injector getInjector() {
        return UmlPropertyActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.property.xtext.UmlProperty");
    }

    public ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        Value newDefault;
        ValueSpecification currentDefault;
        IEditCommandRequest request;
        ICommand updateMultiplicity;
        Property property = (Property)modelObject;
        xtextObject = EcoreUtil2.getContainerOfType((EObject)xtextObject, PropertyRule.class);
        PropertyRule propertyRuleObject = (PropertyRule)xtextObject;
        CompositeCommand updateCommand = new CompositeCommand("Property update");
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)property);
        boolean newIsDerived = propertyRuleObject.isDerived();
        if (propertyRuleObject.getModifiers() != null) {
            boolean newIsOrdered = false;
            boolean newIsReadOnly = false;
            boolean newIsUnion = false;
            boolean newIsUnique = false;
            LinkedList<Property> newRedefines = new LinkedList<Property>();
            LinkedList<Property> newSubsets = new LinkedList<Property>();
            for (ModifierSpecification modifier : propertyRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null || modifier.getSubsets() != null) continue;
                switch (modifier.getValue()) {
                    case ORDERED: {
                        newIsOrdered = true;
                        break;
                    }
                    case READ_ONLY: {
                        newIsReadOnly = true;
                        break;
                    }
                    case UNION: {
                        newIsUnion = true;
                        break;
                    }
                    case UNIQUE: {
                        newIsUnique = true;
                        break;
                    }
                }
            }
            for (ModifierSpecification modifier : propertyRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null) {
                    newRedefines.add(modifier.getRedefines().getProperty());
                    continue;
                }
                if (modifier.getSubsets() == null) continue;
                newSubsets.add(modifier.getSubsets().getProperty());
            }
            SetRequest setIsReadOnlyRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly(), (Object)newIsReadOnly);
            ICommand setIsReadOnlyCommand = provider.getEditCommand((IEditCommandRequest)setIsReadOnlyRequest);
            updateCommand.add((IUndoableOperation)setIsReadOnlyCommand);
            SetRequest setIsUniqueRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique(), (Object)newIsUnique);
            ICommand setIsUniqueCommand = provider.getEditCommand((IEditCommandRequest)setIsUniqueRequest);
            updateCommand.add((IUndoableOperation)setIsUniqueCommand);
            SetRequest setIsDerivedUnionRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerivedUnion(), (Object)newIsUnion);
            ICommand setIsDerivedUnionCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedUnionRequest);
            updateCommand.add((IUndoableOperation)setIsDerivedUnionCommand);
            SetRequest setIsOrderedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered(), (Object)newIsOrdered);
            ICommand setIsOrderedCommand = provider.getEditCommand((IEditCommandRequest)setIsOrderedRequest);
            updateCommand.add((IUndoableOperation)setIsOrderedCommand);
            SetRequest setRedefinedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_RedefinedProperty(), newRedefines);
            ICommand setRedefinedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setRedefinedPropertiesRequest);
            updateCommand.add((IUndoableOperation)setRedefinedPropertiesCommand);
            SetRequest setSubsettedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_SubsettedProperty(), newSubsets);
            ICommand setSubsettedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setSubsettedPropertiesRequest);
            updateCommand.add((IUndoableOperation)setSubsettedPropertiesCommand);
        }
        if (propertyRuleObject.getMultiplicity() != null && (updateMultiplicity = this.updateMultiplicityCommand(provider, (EObject)property, propertyRuleObject)) != null) {
            updateCommand.add((IUndoableOperation)updateMultiplicity);
        }
        if (propertyRuleObject.getDefault() != null && (request = (IEditCommandRequest)new UmlPropertySwitch<IEditCommandRequest>(currentDefault = property.getDefaultValue(), property){
            private final /* synthetic */ ValueSpecification val$currentDefault;
            private final /* synthetic */ Property val$property;
            {
                this.val$currentDefault = valueSpecification;
                this.val$property = property;
            }

            public SetRequest caseBooleanValue(BooleanValue object) {
                boolean booleanValue;
                boolean bl = booleanValue = object.getLiteralBoolean() == BooleanLiterals.TRUE;
                if (this.val$currentDefault instanceof LiteralBoolean) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralBoolean_Value(), (Object)booleanValue);
                }
                LiteralBoolean literalBoolean = UMLFactory.eINSTANCE.createLiteralBoolean();
                literalBoolean.setValue(booleanValue);
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalBoolean);
            }

            public SetRequest caseStringValue(StringValue object) {
                String stringValue = object.getLiteralString();
                if (this.val$currentDefault instanceof LiteralString) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralString_Value(), (Object)stringValue);
                }
                LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
                literalString.setValue(stringValue);
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalString);
            }

            public SetRequest caseIntValue(IntValue object) {
                Integer integerValue;
                try {
                    integerValue = object.getLiteralInteger();
                }
                catch (NumberFormatException ex) {
                    integerValue = 0;
                }
                if (this.val$currentDefault instanceof LiteralInteger) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralInteger_Value(), (Object)integerValue);
                }
                LiteralInteger literalInteger = UMLFactory.eINSTANCE.createLiteralInteger();
                literalInteger.setValue(integerValue.intValue());
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalInteger);
            }

            public SetRequest caseRealValue(RealValue object) {
                Double realValue;
                String literalDouble = "" + object.getInteger() + '.' + object.getFraction();
                try {
                    realValue = Double.parseDouble(literalDouble);
                }
                catch (NumberFormatException ex) {
                    realValue = 0.0;
                }
                if (this.val$currentDefault instanceof LiteralReal) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralReal_Value(), (Object)realValue);
                }
                LiteralReal literalReal = UMLFactory.eINSTANCE.createLiteralReal();
                literalReal.setValue(realValue.doubleValue());
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalReal);
            }

            public IEditCommandRequest caseNullValue(NullValue object) {
                if (this.val$property.getDefaultValue() instanceof LiteralNull) {
                    return null;
                }
                LiteralNull literalNull = UMLFactory.eINSTANCE.createLiteralNull();
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalNull);
            }

            public IEditCommandRequest caseNoValue(NoValue object) {
                if (this.val$property.getDefaultValue() == null) {
                    return null;
                }
                return new DestroyElementRequest((EObject)this.val$property.getDefaultValue(), false);
            }
        }.doSwitch((EObject)(newDefault = propertyRuleObject.getDefault().getDefault()))) != null) {
            ICommand setDefaultValueCommand = provider.getEditCommand(request);
            updateCommand.add((IUndoableOperation)setDefaultValueCommand);
        }
        String newName = ALFIDConverter.IDtoName((String)propertyRuleObject.getName());
        Classifier newType = null;
        boolean setType = false;
        TypeRule typeRule = propertyRuleObject.getType();
        if (propertyRuleObject.isTypeUndefined()) {
            setType = true;
        } else if (typeRule != null) {
            newType = typeRule.getType();
            boolean bl = setType = newType != property.getType();
        }
        if (setType) {
            SetRequest setTypeRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)newType);
            ICommand setTypeCommand = provider.getEditCommand((IEditCommandRequest)setTypeRequest);
            updateCommand.add((IUndoableOperation)setTypeCommand);
        }
        if (propertyRuleObject.getVisibility() != null) {
            VisibilityKind newVisibility = VisibilityKind.PUBLIC_LITERAL;
            switch (propertyRuleObject.getVisibility().getVisibility()) {
                case PUBLIC: {
                    newVisibility = VisibilityKind.PUBLIC_LITERAL;
                    break;
                }
                case PACKAGE: {
                    newVisibility = VisibilityKind.PACKAGE_LITERAL;
                    break;
                }
                case PRIVATE: {
                    newVisibility = VisibilityKind.PRIVATE_LITERAL;
                    break;
                }
                case PROTECTED: {
                    newVisibility = VisibilityKind.PROTECTED_LITERAL;
                    break;
                }
            }
            SetRequest setVisibilityRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Visibility(), (Object)newVisibility);
            ICommand setVisibilityCommand = provider.getEditCommand((IEditCommandRequest)setVisibilityRequest);
            updateCommand.add((IUndoableOperation)setVisibilityCommand);
        }
        SetRequest setIsDerivedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerived(), (Object)newIsDerived);
        ICommand setIsDerivedCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedRequest);
        updateCommand.add((IUndoableOperation)setIsDerivedCommand);
        SetRequest setNameRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName);
        ICommand setNameCommand = provider.getEditCommand((IEditCommandRequest)setNameRequest);
        updateCommand.add((IUndoableOperation)setNameCommand);
        return updateCommand;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Property) {
            return UMLPropertyEditorPropertyUtil.getLabel((Property)editedObject).trim();
        }
        return "not a Property";
    }

    private ICommand updateMultiplicityCommand(IElementEditService provider, EObject eObject, PropertyRule propertyRuleObject) {
        ICommand result = null;
        result = propertyRuleObject.getMultiplicity().getBounds().size() == 1 ? MultiplicityXTextParserUtils.updateOneMultiplicityCommand((IElementEditService)provider, (EObject)eObject, (String)((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(0)).getValue()) : MultiplicityXTextParserUtils.updateTwoMultiplicityCommand((IElementEditService)provider, (EObject)eObject, (String)((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(0)).getValue(), (String)((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(1)).getValue());
        return result;
    }
}

