/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.adapters.ResourceSetRootsAdapter;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.resource.UMLResource;

public class SemanticUMLContentProvider
extends SemanticEMFContentProvider {
    protected static URI[] excludedModels = new URI[]{URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), URI.createURI((String)"pathmap://UML_METAMODELS/Ecore.metamodel.uml")};
    private ResourceSet root;
    private Viewer viewer;
    private RootsAdapter rootsAdapter = new RootsAdapter();

    public SemanticUMLContentProvider() {
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, EObject[] roots) {
        super(editedEObject, feature, roots);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature) {
        this(editedEObject, feature, SemanticUMLContentProvider.findRoots(editedEObject));
    }

    public SemanticUMLContentProvider(EObject[] roots) {
        super(roots);
    }

    public SemanticUMLContentProvider(ResourceSet root) {
        this(null, null, root);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, ResourceSet root) {
        this(editedEObject, feature, SemanticUMLContentProvider.getRoots(root));
        this.root = root;
    }

    protected static EObject[] findRoots(EObject source) {
        if (source.eResource() == null || source.eResource().getResourceSet() == null) {
            return SemanticEMFContentProvider.findRoots((EObject)source);
        }
        return SemanticUMLContentProvider.getRoots(source.eResource().getResourceSet());
    }

    protected static EObject[] getRoots(ResourceSet root) {
        EObject rootElement;
        block7: {
            block6: {
                if (root == null) {
                    return new EObject[0];
                }
                rootElement = null;
                if (!(root instanceof ModelSet)) break block6;
                ModelSet modelSet = (ModelSet)root;
                Object umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (umlModel == null) break block7;
                try {
                    rootElement = ((UmlModel)((Object)umlModel)).lookupRoot();
                }
                catch (NotFoundException notFoundException) {}
                break block7;
            }
            for (Resource resource : root.getResources()) {
                if (!"uml".equals(resource.getURI().fileExtension()) || resource.getContents().isEmpty()) continue;
                rootElement = (EObject)resource.getContents().get(0);
                break;
            }
        }
        LinkedList<EObject> rootElements = new LinkedList<EObject>();
        for (Resource resource : root.getResources()) {
            if (!SemanticUMLContentProvider.isUMLModel(resource, rootElement)) continue;
            for (EObject rootEObject : resource.getContents()) {
                if (!(rootEObject instanceof Element)) continue;
                rootElements.add(rootEObject);
            }
        }
        return rootElements.toArray(new EObject[0]);
    }

    protected static boolean isUMLModel(Resource resource, EObject rootElement) {
        if (!SemanticUMLContentProvider.isUMLResource(resource)) {
            return false;
        }
        URI[] uRIArray = excludedModels;
        int n = excludedModels.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (uri.equals(resource.getURI())) {
                return false;
            }
            ++n2;
        }
        for (EObject rootObject : resource.getContents()) {
            if (rootObject.eIsProxy()) continue;
            if (rootObject.eContainer() != null) {
                return false;
            }
            if (!(rootObject instanceof Profile) || rootElement instanceof Profile) continue;
            return false;
        }
        return true;
    }

    protected static boolean isUMLResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof UMLResource) {
            return true;
        }
        URI uri = resource.getURI();
        return uri != null && "uml".equals(uri.fileExtension());
    }

    protected boolean isCompatibleMetaclass(Object containerElement, Object metaclass) {
        Element semanticElement = UMLUtil.resolveUMLElement((Object)containerElement);
        if (semanticElement == null) {
            return false;
        }
        if (metaclass instanceof Stereotype) {
            boolean res;
            Stereotype stereotype = (Stereotype)metaclass;
            boolean bl = res = semanticElement.getAppliedStereotype(stereotype.getQualifiedName()) != null;
            if (!res) {
                EClass definition = stereotype.getDefinition();
                for (EObject e : semanticElement.getStereotypeApplications()) {
                    EClass c = e.eClass();
                    if (definition == null || !definition.isSuperTypeOf(c)) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        if (metaclass instanceof EClass) {
            EClass metaEClass = (EClass)metaclass;
            for (EObject stereotypeApplication : semanticElement.getStereotypeApplications()) {
                if (!metaEClass.isSuperTypeOf(stereotypeApplication.eClass())) continue;
                return true;
            }
        }
        if (metaclass instanceof EClassifier) {
            return ((EClassifier)metaclass).isInstance((Object)semanticElement);
        }
        return false;
    }

    public Object getAdaptedValue(Object containerElement) {
        Object semanticElement = super.getAdaptedValue(containerElement);
        if (semanticElement instanceof Element) {
            Element element = (Element)semanticElement;
            for (Object metaclassWanted : this.getWantedMetaclasses()) {
                if (metaclassWanted instanceof Stereotype) {
                    EObject stereotypeApplication = null;
                    stereotypeApplication = element.getStereotypeApplication((Stereotype)metaclassWanted);
                    if (stereotypeApplication == null) {
                        EList subStereotypes = element.getAppliedSubstereotypes((Stereotype)metaclassWanted);
                        for (Stereotype subSteretoype : subStereotypes) {
                            stereotypeApplication = element.getStereotypeApplication(subSteretoype);
                            if (stereotypeApplication != null) break;
                        }
                    }
                    if (stereotypeApplication == null) continue;
                    return stereotypeApplication;
                }
                if (!(metaclassWanted instanceof EClass)) continue;
                EClass metaEClassWanted = (EClass)metaclassWanted;
                for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                    if (!metaEClassWanted.isSuperTypeOf(stereotypeApplication.eClass())) continue;
                    return stereotypeApplication;
                }
            }
        }
        return semanticElement;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ResourceSet resourceSet = this.root;
        if (newInput instanceof ResourceSet) {
            resourceSet = (ResourceSet)newInput;
        } else if (newInput instanceof ServicesRegistry) {
            try {
                resourceSet = ServiceUtils.getInstance().getModelSet((Object)((ServicesRegistry)newInput));
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (newInput == null) {
            this.rootsAdapter.detach(this.root);
        } else {
            this.listenOnResourceSet(resourceSet);
        }
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
    }

    protected void listenOnResourceSet(ResourceSet resourceSet) {
        if (this.root != null) {
            this.rootsAdapter.detach(this.root);
            this.root = null;
            this.roots = null;
        }
        if (resourceSet != null) {
            this.rootsAdapter.attach(resourceSet);
            this.root = resourceSet;
            this.roots = SemanticUMLContentProvider.getRoots(this.root);
        }
    }

    public void dispose() {
        if (this.root != null) {
            this.rootsAdapter.detach(this.root);
        }
        this.root = null;
        this.roots = null;
        this.viewer = null;
        super.dispose();
    }

    private class RootsAdapter {
        private final AtomicReference<Runnable> pendingRefresh = new AtomicReference();
        private Object listener;

        private RootsAdapter() {
        }

        void attach(ResourceSet resourceSet) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
            if (domain != null) {
                ResourceSetRootsAdapter.Transactional rsl = new ResourceSetRootsAdapter.Transactional(){

                    protected void handleResourceSetChangeEvent(ResourceSetChangeEvent event) {
                        RootsAdapter.this.triggerRefresh();
                    }
                };
                domain.addResourceSetListener((ResourceSetListener)rsl);
                this.listener = rsl;
            } else {
                ResourceSetRootsAdapter adapter = new ResourceSetRootsAdapter(){

                    protected void doNotify(Notification msg) {
                        if (SemanticUMLContentProvider.this.root == null || msg.isTouch()) {
                            return;
                        }
                        switch (msg.getEventType()) {
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                RootsAdapter.this.triggerRefresh();
                            }
                        }
                    }
                };
                adapter.setTarget((Notifier)resourceSet);
                this.listener = adapter;
            }
        }

        void detach(ResourceSet resourceSet) {
            if (this.listener instanceof ResourceSetRootsAdapter.Transactional) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
                if (domain != null) {
                    domain.removeResourceSetListener((ResourceSetListener)this.listener);
                    this.listener = null;
                }
            } else if (this.listener instanceof ResourceSetRootsAdapter) {
                ((ResourceSetRootsAdapter)this.listener).unsetTarget((Notifier)resourceSet);
                this.listener = null;
            }
        }

        private synchronized void triggerRefresh() {
            SemanticUMLContentProvider.this.roots = SemanticUMLContentProvider.getRoots(SemanticUMLContentProvider.this.root);
            if (SemanticUMLContentProvider.this.viewer != null && SemanticUMLContentProvider.this.viewer.getControl() != null && !SemanticUMLContentProvider.this.viewer.getControl().isDisposed() && this.pendingRefresh.compareAndSet(null, new Runnable(){

                @Override
                public void run() {
                    if (!RootsAdapter.this.pendingRefresh.compareAndSet(this, null) || SemanticUMLContentProvider.this.viewer == null || SemanticUMLContentProvider.this.viewer.getControl() == null || SemanticUMLContentProvider.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    SemanticUMLContentProvider.this.roots = SemanticUMLContentProvider.getRoots(SemanticUMLContentProvider.this.root);
                    SemanticUMLContentProvider.this.viewer.refresh();
                }
            })) {
                SemanticUMLContentProvider.this.viewer.getControl().getDisplay().asyncExec(this.pendingRefresh.get());
            }
        }
    }
}

