/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.swt.widgets.Composite;

public class DirectEditorEditingSupport
extends EditingSupport {
    public DirectEditorEditingSupport(ColumnViewer viewer) {
        super(viewer);
    }

    protected CellEditor getCellEditor(Object element) {
        ICustomDirectEditorConfiguration configuration = DirectEditorEditingSupport.getConfigurationAE(element);
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        Composite parent = (Composite)this.getViewer().getControl();
        configuration.preEditAction((Object)semanticObject);
        return configuration.createCellEditor(parent, semanticObject);
    }

    protected boolean canEdit(Object element) {
        return DirectEditorEditingSupport.getConfigurationAE(element) != null;
    }

    protected Object getValue(Object element) {
        ICustomDirectEditorConfiguration configuration = DirectEditorEditingSupport.getConfigurationAE(element);
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        return configuration.createParser(semanticObject).getEditString((IAdaptable)new EObjectAdapter(semanticObject), 0);
    }

    protected void setValue(Object element, Object value) {
        ICustomDirectEditorConfiguration configuration = DirectEditorEditingSupport.getConfigurationAE(element);
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        IParser parser = configuration.createParser(semanticObject);
        ICommand command = parser.getParseCommand((IAdaptable)new EObjectAdapter(semanticObject), (String)value, 0);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)semanticObject);
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(command));
    }

    public static ICustomDirectEditorConfiguration getConfigurationAE(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        return DirectEditorEditingSupport.getConfiguration(semanticObject);
    }

    public static ICustomDirectEditorConfiguration getConfiguration(EObject semanticElement) {
        IDirectEditorConfiguration configuration;
        String semanticClassName;
        String key;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String languagePreferred = store.getString(key = "papyrus.directeditor." + (semanticClassName = semanticElement.eClass().getInstanceClassName()));
        if (languagePreferred != null && !languagePreferred.equals("") && (configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (Object)semanticElement, (Object)semanticElement)) instanceof ICustomDirectEditorConfiguration) {
            return (ICustomDirectEditorConfiguration)configuration;
        }
        return null;
    }
}

