/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.site.SiteLabelProvider;
import org.eclipse.pde.internal.ui.editor.site.SynchronizePropertiesAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Version;

public class CategorySection
extends TreeSection
implements IFeatureModelListener {
    private static final int BUTTON_ADD_CATEGORY = 0;
    private static final int BUTTON_ADD_FEATURE = 1;
    private static final int BUTTON_IMPORT_ENVIRONMENT = 3;
    private static final int BUTTON_BUILD_FEATURE = 5;
    private static final int BUTTON_BUILD_ALL = 6;
    private static int newCategoryCounter;
    private ISiteModel fModel;
    private TreePart fCategoryTreePart;
    private TreeViewer fCategoryViewer;
    private LabelProvider fSiteLabelProvider;
    private ISiteFeature[] cachedFeatures;
    private IStructuredSelection cachedSelection;

    public CategorySection(PDEFormPage formPage, Composite parent) {
        String[] stringArray = new String[7];
        stringArray[0] = PDEUIMessages.CategorySection_new;
        stringArray[1] = PDEUIMessages.CategorySection_add;
        stringArray[3] = PDEUIMessages.CategorySection_environment;
        stringArray[5] = PDEUIMessages.CategorySection_build;
        stringArray[6] = PDEUIMessages.CategorySection_buildAll;
        super(formPage, parent, 128, stringArray);
        this.getSection().setText(PDEUIMessages.CategorySection_title);
        this.getSection().setDescription(PDEUIMessages.CategorySection_desc);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fCategoryTreePart = this.getTreePart();
        this.fCategoryViewer = this.fCategoryTreePart.getTreeViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fSiteLabelProvider = new SiteLabelProvider();
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)this.fSiteLabelProvider);
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
        int ops = 19;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        if (this.isEditable()) {
            this.fCategoryViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fCategoryViewer){

                public void dragEnter(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragEnter(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOver(event);
                }

                protected int determineLocation(DropTargetEvent event) {
                    Rectangle bounds;
                    if (!(event.item instanceof Item)) {
                        return 4;
                    }
                    Item item = (Item)event.item;
                    Point coordinates = new Point(event.x, event.y);
                    coordinates = this.getViewer().getControl().toControl(coordinates);
                    if (item != null && (bounds = this.getBounds(item)) == null) {
                        return 4;
                    }
                    return 3;
                }

                public boolean performDrop(Object data) {
                    if (!(data instanceof Object[])) {
                        return false;
                    }
                    Object target = this.getCurrentTarget();
                    int op = this.getCurrentOperation();
                    Object[] objects = (Object[])data;
                    if (objects.length > 0 && objects[0] instanceof SiteFeatureAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyFeature((SiteFeatureAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveFeature((SiteFeatureAdapter)objects[0], target);
                        }
                        return true;
                    }
                    return false;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    return target instanceof ISiteCategoryDefinition || target == null;
                }
            });
        }
        this.fCategoryViewer.addDragSupport(3, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                if (ssel == null || ssel.isEmpty() || !(ssel.getFirstElement() instanceof SiteFeatureAdapter)) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.fCategoryTreePart.setButtonEnabled(0, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(1, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(5, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(6, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean categoryExists(String name) {
        ISiteCategoryDefinition[] defs = this.fModel.getSite().getCategoryDefinitions();
        int i = 0;
        while (i < defs.length) {
            ISiteCategoryDefinition def = defs[i];
            String dname = def.getName();
            if (dname != null && dname.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void copyFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            try {
                feature = this.copySiteFeature(this.fModel, adapter.feature);
                this.fModel.getSite().addFeatures(new ISiteFeature[]{feature});
            }
            catch (CoreException coreException) {
                return;
            }
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    private void addCategory(ISiteFeature aFeature, String catName) {
        try {
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] cats = aFeature.getCategories();
            int j = 0;
            while (j < cats.length) {
                if (cats[j].getName().equals(catName)) {
                    return;
                }
                ++j;
            }
            ISiteCategory cat = this.fModel.getFactory().createCategory(aFeature);
            cat.setName(catName);
            this.expandCategory(catName);
            aFeature.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void moveFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(feature, adapter.category);
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddCategoryDefinition();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 5: {
                this.handleBuild();
                break;
            }
            case 6: {
                ((SiteEditor)this.getPage().getPDEEditor()).handleBuild(this.fModel.getSite().getFeatures());
                break;
            }
            case 3: {
                this.handleImportEnvironment();
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection ssel) {
        super.handleDoubleClick(ssel);
        Object selected = ssel.getFirstElement();
        if (selected instanceof SiteFeatureAdapter) {
            IFeature feature = CategorySection.findFeature(((SiteFeatureAdapter)selected).feature);
            FeatureEditor.openFeatureEditor(feature);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    private void handleAddCategoryDefinition() {
        String name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++newCategoryCounter));
        while (this.categoryExists(name)) {
            name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++newCategoryCounter));
        }
        String label = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryLabel, (Object)Integer.toString(newCategoryCounter));
        ISiteCategoryDefinition categoryDef = this.fModel.getFactory().createCategoryDefinition();
        try {
            categoryDef.setName(name);
            categoryDef.setLabel(label);
            this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{categoryDef});
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)categoryDef), true);
    }

    private boolean handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        Iterator iterator = ssel.iterator();
        boolean success = true;
        HashSet removedCategories = new HashSet();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (object instanceof ISiteCategoryDefinition) {
                if (this.handleRemoveCategoryDefinition((ISiteCategoryDefinition)object)) continue;
                success = false;
                continue;
            }
            SiteFeatureAdapter fa = (SiteFeatureAdapter)object;
            if (removedCategories.contains(fa.category) || this.handleRemoveSiteFeatureAdapter(fa)) continue;
            success = false;
        }
        return success;
    }

    private boolean handleRemoveCategoryDefinition(ISiteCategoryDefinition catDef) {
        try {
            Object[] children = ((CategoryContentProvider)this.fCategoryViewer.getContentProvider()).getChildren(catDef);
            int i = 0;
            while (i < children.length) {
                SiteFeatureAdapter adapter = (SiteFeatureAdapter)children[i];
                ISiteCategory[] cats = adapter.feature.getCategories();
                int j = 0;
                while (j < cats.length) {
                    if (adapter.category.equals(cats[j].getName())) {
                        adapter.feature.removeCategories(new ISiteCategory[]{cats[j]});
                    }
                    ++j;
                }
                if (adapter.feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{adapter.feature});
                }
                ++i;
            }
            this.fModel.getSite().removeCategoryDefinitions(new ISiteCategoryDefinition[]{catDef});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            if (adapter.category == null) {
                this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
            } else {
                this.removeCategory(feature, adapter.category);
                if (feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeCategory(ISiteFeature aFeature, String catName) {
        try {
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] cats = aFeature.getCategories();
            int i = 0;
            while (i < cats.length) {
                if (catName.equals(cats[i].getName())) {
                    aFeature.removeCategories(new ISiteCategory[]{cats[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature findRealFeature(SiteFeatureAdapter adapter) {
        ISiteFeature featureCopy = adapter.feature;
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getId().equals(featureCopy.getId()) && features[i].getVersion().equals(featureCopy.getVersion())) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.removeFeatureModelListener((IFeatureModelListener)this);
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        if (this.fSiteLabelProvider != null) {
            this.fSiteLabelProvider.dispose();
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ISiteFeature[] features;
        Action removeAction = new Action(PDEUIMessages.CategorySection_remove){

            public void run() {
                CategorySection.this.doGlobalAction(ActionFactory.DELETE.getId());
            }
        };
        removeAction.setEnabled(this.isEditable());
        manager.add((IAction)removeAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (features = this.getFeaturesFromSelection((IStructuredSelection)selection)).length > 0) {
            manager.add((IContributionItem)new Separator());
            SynchronizePropertiesAction synchronizeAction = new SynchronizePropertiesAction(features, this.fModel);
            manager.add((IAction)synchronizeAction);
            Action buildAction = new Action(PDEUIMessages.CategorySection_build){

                public void run() {
                    ((SiteEditor)CategorySection.this.getPage().getPDEEditor()).handleBuild(features);
                }
            };
            buildAction.setEnabled(this.isEditable());
            manager.add((IAction)buildAction);
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return this.handleRemove();
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.fCategoryViewer.getTree().selectAll();
            this.refresh();
        }
        return false;
    }

    public void refresh() {
        this.fCategoryViewer.refresh();
        this.updateButtons();
        super.refresh();
    }

    private void updateButtons() {
        if (!this.isEditable()) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        this.fCategoryTreePart.setButtonEnabled(5, this.getFeaturesFromSelection(sel).length > 0);
        int featureCount = this.fModel.getSite().getFeatures().length;
        this.fCategoryTreePart.setButtonEnabled(6, featureCount > 0);
        this.fCategoryTreePart.setButtonEnabled(3, featureCount > 0);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void initialize() {
        this.refresh();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof SiteFeatureAdapter) {
                    this.copyFeature((SiteFeatureAdapter)objects[i], target);
                } else if (objects[i] instanceof ISiteCategoryDefinition) {
                    this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)objects[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        if (target == null || target instanceof ISiteCategoryDefinition) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof SiteFeatureAdapter) {
                    return true;
                }
                if (objects[i] instanceof ISiteCategoryDefinition) {
                    String name = ((ISiteCategoryDefinition)objects[i]).getName();
                    ISiteCategoryDefinition[] defs = this.fModel.getSite().getCategoryDefinitions();
                    int j = 0;
                    while (j < defs.length) {
                        ISiteCategoryDefinition def = defs[j];
                        String dname = def.getName();
                        if (dname != null && dname.equals(name)) {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void handleBuild() {
        IStructuredSelection sel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        ((SiteEditor)this.getPage().getPDEEditor()).handleBuild(this.getFeaturesFromSelection(sel));
    }

    private ISiteFeature[] getFeaturesFromSelection(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            return new ISiteFeature[0];
        }
        if (this.cachedSelection == sel) {
            return this.cachedFeatures;
        }
        this.cachedSelection = sel;
        ArrayList<ISiteFeature> features = new ArrayList<ISiteFeature>(sel.size());
        for (Object next : sel) {
            if (!(next instanceof SiteFeatureAdapter) || ((SiteFeatureAdapter)next).feature == null) continue;
            features.add(((SiteFeatureAdapter)next).feature);
        }
        this.cachedFeatures = features.toArray(new ISiteFeature[features.size()]);
        return this.cachedFeatures;
    }

    public static IFeature findFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void handleImportEnvironment() {
        IStructuredSelection sel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        final ISiteFeature[] selectedFeatures = this.getFeaturesFromSelection(sel);
        BusyIndicator.showWhile((Display)this.fCategoryTreePart.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                new SynchronizePropertiesAction(selectedFeatures, CategorySection.this.getModel()).run();
            }
        });
    }

    private void handleNewFeature() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
                int i = 0;
                while (i < allModels.length) {
                    if (CategorySection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(CategorySection.this.fCategoryViewer.getTree().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        CategorySection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    private boolean canAdd(IFeatureModel candidate) {
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        IFeature cfeature = candidate.getFeature();
        int i = 0;
        while (i < features.length) {
            ISiteFeature bfeature = features[i];
            if (bfeature.getId().equals(cfeature.getId()) && bfeature.getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ISiteFeature createSiteFeature(ISiteModel model, IFeatureModel featureModel) throws CoreException {
        IFeature feature = featureModel.getFeature();
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(feature.getId());
        sfeature.setVersion(feature.getVersion());
        sfeature.setURL("features/" + feature.getId() + "_" + CategorySection.formatVersion(feature.getVersion()) + ".jar");
        sfeature.setOS(feature.getOS());
        sfeature.setWS(feature.getWS());
        sfeature.setArch(feature.getArch());
        sfeature.setNL(feature.getNL());
        sfeature.setIsPatch(CategorySection.isFeaturePatch(feature));
        return sfeature;
    }

    private static String formatVersion(String version) {
        try {
            Version v = new Version(version);
            return v.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return version;
        }
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ISiteModel getModel() {
        return this.fModel;
    }

    public void doAdd(Object[] candidates) throws CoreException {
        String categoryName = null;
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ISiteCategoryDefinition) {
                categoryName = ((ISiteCategoryDefinition)element).getName();
            } else if (element instanceof SiteFeatureAdapter) {
                categoryName = ((SiteFeatureAdapter)element).category;
            }
        }
        ISiteFeature[] added = new ISiteFeature[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            ISiteFeature child = CategorySection.createSiteFeature(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addFeatures(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteFeatureAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    void fireSelection() {
        this.fCategoryViewer.setSelection(this.fCategoryViewer.getSelection());
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ISiteCategoryDefinition) {
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof SiteFeatureAdapter) {
            String category = ((SiteFeatureAdapter)input).category;
            if (category != null) {
                this.expandCategory(category);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void expandCategory(String category) {
        if (category != null) {
            ISiteCategoryDefinition[] catDefs = this.fModel.getSite().getCategoryDefinitions();
            int i = 0;
            while (i < catDefs.length) {
                if (category.equals(catDefs[i].getName())) {
                    this.fCategoryViewer.expandToLevel((Object)catDefs[i], 1);
                    break;
                }
                ++i;
            }
        }
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.markStale();
    }

    private ISiteFeature copySiteFeature(ISiteModel model, ISiteFeature sourceFeature) throws CoreException {
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(sourceFeature.getId());
        sfeature.setVersion(sourceFeature.getVersion());
        sfeature.setURL(sourceFeature.getURL());
        sfeature.setOS(sourceFeature.getOS());
        sfeature.setWS(sourceFeature.getWS());
        sfeature.setArch(sourceFeature.getArch());
        sfeature.setNL(sourceFeature.getNL());
        sfeature.setIsPatch(sourceFeature.isPatch());
        return sfeature;
    }

    class CategoryContentProvider
    implements ITreeContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> result = new ArrayList<Object>();
            ISiteCategoryDefinition[] catDefs = CategorySection.this.fModel.getSite().getCategoryDefinitions();
            int i = 0;
            while (i < catDefs.length) {
                result.add(catDefs[i]);
                ++i;
            }
            ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
            int i2 = 0;
            while (i2 < features.length) {
                if (features[i2].getCategories().length == 0) {
                    result.add(new SiteFeatureAdapter(null, features[i2]));
                }
                ++i2;
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)parent;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                HashSet<SiteFeatureAdapter> result = new HashSet<SiteFeatureAdapter>();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            result.add(new SiteFeatureAdapter(cats[j].getName(), features[i]));
                        }
                        ++j;
                    }
                    ++i;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)element;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

