/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.RefactoringInfo;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public class RenameExtensionPointProcessor
extends RefactoringProcessor {
    RefactoringInfo fInfo;

    public RenameExtensionPointProcessor(RefactoringInfo info) {
        this.fInfo = info;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IResource res = this.fInfo.getBase().getUnderlyingResource();
        if (res == null) {
            status.addFatalError(PDEUIMessages.RenamePluginProcessor_externalBundleError);
        }
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(MessageFormat.format((String)PDEUIMessages.RenameExtensionPointProcessor_changeTitle, (Object[])new Object[]{this.fInfo.getCurrentValue(), this.fInfo.getNewValue()}));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        this.changeExtensionPoint(change, (IProgressMonitor)subMonitor.split(1));
        if (this.fInfo.isUpdateReferences()) {
            this.findReferences(change, (IProgressMonitor)subMonitor.split(1));
        }
        return change;
    }

    public Object[] getElements() {
        return new Object[]{this.fInfo.getSelection()};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PDEUIMessages.RenameExtensionPointProcessor_processorName;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected void changeExtensionPoint(CompositeChange compositeChange, IProgressMonitor monitor) {
        IFile file = this.getModificationFile(this.fInfo.getBase());
        if (file != null) {
            compositeChange.addAll((Change[])PDEModelUtility.changesForModelModication(this.getExtensionPointModification(file), monitor));
        }
    }

    private void findReferences(CompositeChange compositeChange, IProgressMonitor monitor) {
        String pointId = this.getId();
        IPluginModelBase[] bases = PDECore.getDefault().getExtensionsRegistry().findExtensionPlugins(pointId, true);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)bases.length);
        int i = 0;
        while (i < bases.length) {
            IFile file = this.getModificationFile(bases[i]);
            if (file != null) {
                compositeChange.addAll((Change[])PDEModelUtility.changesForModelModication(this.getExtensionModification(file), (IProgressMonitor)subMonitor.split(1)));
            }
            subMonitor.setWorkRemaining(bases.length - i);
            ++i;
        }
    }

    private String getId() {
        String currentValue = this.fInfo.getCurrentValue();
        if (currentValue.indexOf(46) > 0) {
            return currentValue;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fInfo.getBase().getUnderlyingResource().getProject());
        return base == null ? currentValue : String.valueOf(base.getPluginBase().getId()) + "." + currentValue;
    }

    private String getNewId() {
        String newValue = this.fInfo.getNewValue();
        if (newValue.indexOf(46) > 0) {
            return newValue;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fInfo.getBase().getUnderlyingResource().getProject());
        return base == null ? newValue : String.valueOf(base.getPluginBase().getId()) + "." + newValue;
    }

    private IFile getModificationFile(IPluginModelBase base) {
        IProject proj;
        IFile file;
        IResource res = base.getUnderlyingResource();
        if (res != null && (file = PDEProject.getPluginXml((IProject)(proj = res.getProject()))).exists()) {
            return file;
        }
        return null;
    }

    protected ModelModification getExtensionPointModification(IFile file) {
        return new ModelModification(file){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IPluginModelBase)) {
                    return;
                }
                IPluginModelBase modelBase = (IPluginModelBase)model;
                IPluginBase base = modelBase.getPluginBase();
                IPluginExtensionPoint[] points = base.getExtensionPoints();
                int i = 0;
                while (i < points.length) {
                    if (points[i].getId().equals(RenameExtensionPointProcessor.this.fInfo.getCurrentValue())) {
                        points[i].setId(RenameExtensionPointProcessor.this.fInfo.getNewValue());
                    }
                    ++i;
                }
            }
        };
    }

    protected ModelModification getExtensionModification(IFile file) {
        return new ModelModification(file){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IPluginModelBase)) {
                    return;
                }
                IPluginModelBase modelBase = (IPluginModelBase)model;
                IPluginBase base = modelBase.getPluginBase();
                IPluginExtension[] extensions = base.getExtensions();
                String oldValue = RenameExtensionPointProcessor.this.getId();
                int i = 0;
                while (i < extensions.length) {
                    if (extensions[i].getPoint().equals(oldValue)) {
                        extensions[i].setPoint(RenameExtensionPointProcessor.this.getNewId());
                    }
                    ++i;
                }
            }
        };
    }
}

