/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.cdtinterface.makegen;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.photran.internal.cdtinterface.core.FortranLanguage;

public class DefaultFortranDependencyCalculator
implements IManagedDependencyGenerator,
IManagedOutputNameProvider {
    public static final String MODULE_EXTENSION = "o";

    private String[] findUsedModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        BufferedInputStream in = null;
        Reader r = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                r = new BufferedReader(new InputStreamReader(in));
                StreamTokenizer st = new StreamTokenizer(r);
                st.commentChar(33);
                st.eolIsSignificant(false);
                st.slashSlashComments(false);
                st.slashStarComments(false);
                st.wordChars(95, 95);
                while (st.nextToken() != -1) {
                    if (st.ttype != -3 || !st.sval.equalsIgnoreCase("use")) continue;
                    st.nextToken();
                    if (st.ttype == -3) {
                        names.add(st.sval);
                        continue;
                    }
                    st.pushBack();
                }
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{};
                try {
                    if (r != null) {
                        r.close();
                    } else if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            try {
                if (r != null) {
                    r.close();
                } else if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (r != null) {
                r.close();
            } else if (in != null) {
                ((InputStream)in).close();
            }
        }
        catch (IOException iOException) {}
        return names.toArray(new String[names.size()]);
    }

    private String[] findModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        BufferedInputStream in = null;
        Reader r = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                r = new BufferedReader(new InputStreamReader(in));
                StreamTokenizer st = new StreamTokenizer(r);
                st.commentChar(33);
                st.eolIsSignificant(false);
                st.slashSlashComments(false);
                st.slashStarComments(false);
                st.wordChars(95, 95);
                while (st.nextToken() != -1) {
                    if (st.ttype != -3 || !st.sval.equalsIgnoreCase("module")) continue;
                    st.nextToken();
                    if (st.ttype == -3) {
                        names.add(st.sval);
                        continue;
                    }
                    st.pushBack();
                }
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{};
                try {
                    if (r != null) {
                        r.close();
                    } else if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            try {
                if (r != null) {
                    r.close();
                } else if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (r != null) {
                r.close();
            } else if (in != null) {
                ((InputStream)in).close();
            }
        }
        catch (IOException iOException) {}
        return names.toArray(new String[names.size()]);
    }

    private boolean isFortranFile(IProject project, File file, Collection fortranContentTypes) {
        try {
            IContentType ct = CCorePlugin.getContentType((IProject)project, (String)file.getCanonicalPath());
            if (ct != null) {
                return fortranContentTypes.contains(ct.toString());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private IResource[] FindModulesInResources(IProject project, Collection contentTypes, IResource resource, IResource[] resourcesToSearch, String topBuildDir, String[] usedNames) {
        IResource[] res = null;
        try {
            res = project.members();
        }
        catch (CoreException coreException) {
            throw new Error("No files found in the given project");
        }
        ArrayList<Object> modRes = new ArrayList<Object>();
        int ir = 0;
        while (ir < resourcesToSearch.length) {
            if (!resourcesToSearch[ir].equals((Object)resource)) {
                if (resourcesToSearch[ir].getType() == 1) {
                    String[] modules;
                    File projectFile = resourcesToSearch[ir].getLocation().toFile();
                    if (this.isFortranFile(project, projectFile, contentTypes) && (modules = this.findModuleNames(projectFile)) != null) {
                        int iu = 0;
                        while (iu < usedNames.length) {
                            boolean foundDependency = false;
                            int im = 0;
                            while (im < modules.length) {
                                if (usedNames[iu].equalsIgnoreCase(modules[im])) {
                                    IPath modName = this.getModulePath(topBuildDir, modules[im], res, project);
                                    modRes.add(project.getFile(modName));
                                    foundDependency = true;
                                    break;
                                }
                                ++im;
                            }
                            if (!foundDependency) {
                                ++iu;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (resourcesToSearch[ir].getType() == 2 && !((IFolder)resourcesToSearch[ir]).isDerived()) {
                    try {
                        IResource[] modFound = this.FindModulesInResources(project, contentTypes, resource, ((IFolder)resourcesToSearch[ir]).members(), topBuildDir, usedNames);
                        if (modFound != null) {
                            int i = 0;
                            while (i < modFound.length) {
                                modRes.add(modFound[i]);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++ir;
        }
        return modRes.toArray(new IResource[modRes.size()]);
    }

    private IPath getModulePath(String topBuildDir, String moduleName, IResource[] resources, IProject project) {
        String fileNameContainingModule = this.getFileNameContainingModule(moduleName, resources, topBuildDir);
        if (fileNameContainingModule == null || fileNameContainingModule == "") {
            this.removeDir(new File(String.valueOf(project.getLocation().toString()) + '/' + topBuildDir));
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                throw new Error("Could not update the project");
            }
            throw new Error("Could not find a file to match the module name: " + moduleName);
        }
        IPath p = Path.fromOSString((String)("./" + topBuildDir + '/' + fileNameContainingModule + "." + MODULE_EXTENSION));
        return p;
    }

    private String getFileNameContainingModule(String moduleName, IResource[] resources, String buildDirName) {
        ArrayList<String> possibleMatchingFiles = new ArrayList<String>();
        if (resources == null || resources.length < 1 || moduleName == null || moduleName == "") {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFile) {
                IFile f = (IFile)resources[i];
                String fileName = f.getName().replaceFirst("\\..+", "");
                if (fileName == moduleName) {
                    return f.getProjectRelativePath().toString().replaceFirst("\\..+", "");
                }
                if (fileName.equalsIgnoreCase(moduleName)) {
                    possibleMatchingFiles.add(f.getProjectRelativePath().toString().replaceFirst("\\..+", ""));
                }
            } else if (resources[i] instanceof IContainer && !resources[i].isDerived()) {
                IContainer folder = (IContainer)resources[i];
                IResource[] subResource = null;
                if (!folder.getName().equalsIgnoreCase(buildDirName)) {
                    try {
                        subResource = folder.members();
                    }
                    catch (CoreException coreException) {
                        throw new Error("Could not open a container to explore its files");
                    }
                    String name = this.getFileNameContainingModule(moduleName, subResource, buildDirName);
                    if (name != null) {
                        return name;
                    }
                }
            }
            ++i;
        }
        if (possibleMatchingFiles.size() == 1) {
            return (String)possibleMatchingFiles.get(0);
        }
        return null;
    }

    private void removeDir(File f) {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.removeDir(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        f.delete();
    }

    public IResource[] findDependencies(IResource resource, IProject project) {
        ArrayList<IResource> dependencies = new ArrayList<IResource>();
        Collection fortranContentTypes = new FortranLanguage().getRegisteredContentTypeIds();
        IManagedBuildInfo mngInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = mngInfo.getDefaultConfiguration();
        File file = resource.getLocation().toFile();
        try {
            IResource[] resources;
            IResource[] modRes;
            if (!this.isFortranFile(project, file, fortranContentTypes)) {
                return new IResource[0];
            }
            dependencies.add(resource);
            String[] usedNames = this.findUsedModuleNames(file);
            if (usedNames.length != 0 && (modRes = this.FindModulesInResources(project, fortranContentTypes, resource, resources = project.members(), config.getName(), usedNames)) != null) {
                int i = 0;
                while (i < modRes.length) {
                    dependencies.add(modRes[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            return new IResource[0];
        }
        return dependencies.toArray(new IResource[dependencies.size()]);
    }

    public int getCalculatorType() {
        return 3;
    }

    public String getDependencyCommand(IResource resource, IManagedBuildInfo info) {
        return null;
    }

    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        String[] modules;
        ArrayList<IPath> outs = new ArrayList<IPath>();
        if (primaryInputNames.length > 0 && (modules = this.findModuleNames(primaryInputNames[0].toFile())) != null) {
            int i = 0;
            while (i < modules.length) {
                IPath modName = Path.fromOSString((String)("./" + modules[i] + "." + MODULE_EXTENSION));
                outs.add(modName);
                ++i;
            }
        }
        return outs.toArray(new IPath[outs.size()]);
    }
}

