/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.photran.internal.ui.ContributedAPIDocs;
import org.eclipse.ui.texteditor.ITextEditor;

public class FortranHelpContextProvider
implements IContextProvider {
    private final ITextEditor fEditor;

    public FortranHelpContextProvider(ITextEditor editor) {
        this.fEditor = editor;
    }

    public IContext getContext(Object target) {
        String selected = FortranHelpContextProvider.getSelectedString(this.fEditor);
        String preceding = FortranHelpContextProvider.getPrecedingString(this.fEditor);
        IContext context = HelpSystem.getContext((String)"org.eclipse.photran.ui.editor");
        if (context != null && selected != null && selected.length() > 0) {
            try {
                context = new FortranHelpDisplayContext(context, this.fEditor, selected, preceding);
            }
            catch (CoreException coreException) {}
        }
        return context;
    }

    public int getContextChangeMask() {
        return 1;
    }

    public String getSearchExpression(Object target) {
        return FortranHelpContextProvider.getSelectedString(this.fEditor);
    }

    public static String getSelectedString(ITextEditor editor) {
        String expression = null;
        try {
            ITextSelection selection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IRegion region = FortranHelpContextProvider.findWord(document, selection.getOffset());
            if (region != null) {
                expression = document.get(region.getOffset(), region.getLength());
            }
        }
        catch (Exception exception) {}
        return expression;
    }

    public static String getPrecedingString(ITextEditor editor) {
        String expression = "";
        try {
            ITextSelection selection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IRegion region = FortranHelpContextProvider.findWord(document, selection.getOffset());
            if (region != null) {
                int end = region.getOffset();
                ITypedRegion partition = document.getPartition(end);
                int start = partition.getOffset();
                expression = document.get(start, end - start);
            }
        }
        catch (Exception exception) {}
        return expression;
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (--pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static final class FortranHelpDisplayContext
    implements IContext {
        private final IHelpResource[] helpResources;
        private final String text;

        public FortranHelpDisplayContext(IContext context, ITextEditor editor, String selected, String precedingText) throws CoreException {
            this.text = context.getText();
            this.helpResources = this.getHelpResources(context, editor, selected, precedingText);
        }

        private IHelpResource[] getHelpResources(IContext context, ITextEditor editor, String selected, String precedingText) {
            IHelpResource[] relatedResources;
            ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
            IHelpResource[] apiResources = this.getAPIHelp(editor, selected, precedingText);
            if (apiResources != null) {
                helpResources.addAll(Arrays.asList(apiResources));
            }
            if ((relatedResources = context.getRelatedTopics()) != null) {
                helpResources.addAll(Arrays.asList(relatedResources));
            }
            return helpResources.toArray(new IHelpResource[helpResources.size()]);
        }

        private IHelpResource[] getAPIHelp(ITextEditor fortranEditor, String apiName, String precedingText) {
            return ContributedAPIDocs.getAPIHelp(fortranEditor, apiName, precedingText);
        }

        public IHelpResource[] getRelatedTopics() {
            return this.helpResources;
        }

        public String getText() {
            return this.text;
        }
    }
}

