/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;

public class NamespaceNameContext
extends StatementContext {
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        if (this.getPhpVersion().isLessThan(PHPVersion.PHP5_3)) {
            return false;
        }
        try {
            char[] prefix = this.getPrefix().toCharArray();
            boolean isNamespace = false;
            int i = 0;
            while (i < prefix.length) {
                if (prefix[i] == '\\') {
                    isNamespace = true;
                } else if (!Character.isJavaIdentifierPart(prefix[i])) {
                    isNamespace = false;
                    break;
                }
                ++i;
            }
            return isNamespace;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    @Override
    public String getPrefix() throws BadLocationException {
        String prefix = super.getPrefix();
        if (prefix.length() > 0 && prefix.charAt(0) == '\\') {
            return prefix.substring(1);
        }
        return prefix;
    }
}

