/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.ASTError;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.compiler.ast.parser.FindUseStatementByAliasASTVisitor;
import org.eclipse.php.internal.core.compiler.ast.parser.FindUseStatementByNamespaceASTVisitor;
import org.eclipse.php.internal.core.compiler.ast.parser.GetUseStatementsASTVisitor;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;
import org.eclipse.php.internal.core.typeinference.context.FileContext;

public class ASTUtils {
    private static final Pattern VAR_COMMENT_PATTERN1 = Pattern.compile("(.*?@var\\s+)([$][^$\\s]+)(\\s+)([^$\\s]+).*", 2);
    private static final Pattern VAR_COMMENT_PATTERN2 = Pattern.compile("(.*?@var\\s+)([^$\\s]+)(\\s+)([$][^$\\s]+).*", 2);

    public static VarComment parseVarComment(String content, int start, int end) {
        Matcher m = null;
        String types = null;
        String varName = null;
        int typeStart = -1;
        int varStart = -1;
        int varEnd = -1;
        boolean foundMatch = false;
        m = VAR_COMMENT_PATTERN1.matcher(content);
        if (m.matches()) {
            types = m.group(4);
            varName = m.group(2);
            varStart = start + m.group(1).length();
            varEnd = varStart + varName.length();
            typeStart = varEnd + m.group(3).length();
            foundMatch = true;
        } else {
            m = VAR_COMMENT_PATTERN2.matcher(content);
            if (m.matches()) {
                types = m.group(2);
                varName = m.group(4);
                typeStart = start + m.group(1).length();
                varStart = typeStart + types.length() + m.group(3).length();
                varEnd = varStart + varName.length();
                foundMatch = true;
            }
        }
        if (foundMatch) {
            LinkedList<TypeReference> typeReferences = new LinkedList<TypeReference>();
            if (types != null) {
                int typeEnd;
                String typeName;
                int pipeIdx = types.indexOf(124);
                while (pipeIdx >= 0) {
                    typeName = types.substring(0, pipeIdx);
                    typeEnd = typeStart + typeName.length();
                    if (typeName.length() > 0) {
                        typeReferences.add(new TypeReference(typeStart, typeEnd, typeName));
                    }
                    types = types.substring(pipeIdx + 1);
                    typeStart += pipeIdx + 1;
                    pipeIdx = types.indexOf(124);
                }
                typeName = types;
                typeEnd = typeStart + typeName.length();
                if (typeName.length() > 0) {
                    typeReferences.add(new TypeReference(typeStart, typeEnd, typeName));
                }
            }
            VariableReference varReference = new VariableReference(varStart, varEnd, varName);
            VarComment varComment = new VarComment(start, end, varReference, typeReferences.toArray(new TypeReference[typeReferences.size()]));
            return varComment;
        }
        return null;
    }

    public static String stripQuotes(String name) {
        int len = name.length();
        if (len > 1 && (name.charAt(0) == '\'' && name.charAt(len - 1) == '\'' || name.charAt(0) == '\"' && name.charAt(len - 1) == '\"')) {
            name = name.substring(1, len - 1);
        }
        return name;
    }

    @Nullable
    public static ASTNode findMinimalNode(@Nullable ModuleDeclaration unit, int start, int end) {
        if (unit == null) {
            return null;
        }
        class Visitor
        extends ASTVisitor {
            ASTNode result = null;
            int start;
            int end;

            public Visitor(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public ASTNode getResult() {
                return this.result;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                int realStart = s.sourceStart();
                int realEnd = s.sourceEnd();
                if (s instanceof Block) {
                    realEnd = -42;
                    realStart = -42;
                }
                if (realStart <= this.start && realEnd >= this.end) {
                    if (this.result != null) {
                        if (s.sourceStart() >= this.result.sourceStart() && s.sourceEnd() <= this.result.sourceEnd()) {
                            if (s instanceof ConstantReference && this.result instanceof StaticConstantAccess) {
                                return false;
                            }
                            this.result = s;
                        }
                    } else {
                        this.result = s;
                    }
                    if (DLTKCore.DEBUG_SELECTION) {
                        System.out.println("Found " + s.getClass().getName());
                    }
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(start, end);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getResult();
    }

    public static ASTNode findMaximalNodeEndingAt(ModuleDeclaration unit, int boundaryOffset) {
        class Visitor
        extends ASTVisitor {
            ASTNode result = null;
            private final /* synthetic */ int val$boundaryOffset;

            Visitor(int n) {
                this.val$boundaryOffset = n;
            }

            public ASTNode getResult() {
                return this.result;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                if (s.sourceStart() < 0 || s.sourceEnd() < 0) {
                    return true;
                }
                int sourceEnd = s.sourceEnd();
                if (Math.abs(sourceEnd - this.val$boundaryOffset) <= 0) {
                    this.result = s;
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(boundaryOffset);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static ASTNode[] restoreWayToNode(ModuleDeclaration module, final ASTNode node) {
        final Stack stack = new Stack();
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visitGeneral(ASTNode n) throws Exception {
                if (this.found) {
                    return super.visitGeneral(n);
                }
                stack.push(n);
                if (n.equals(node)) {
                    this.found = true;
                }
                return super.visitGeneral(n);
            }

            public void endvisitGeneral(ASTNode n) throws Exception {
                super.endvisitGeneral(n);
                if (this.found) {
                    return;
                }
                stack.pop();
            }
        };
        try {
            module.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return stack.toArray(new ASTNode[stack.size()]);
    }

    public static IContext findContext(ISourceModule sourceModule, ModuleDeclaration unit, final ASTNode target) {
        ContextFinder visitor = new ContextFinder(sourceModule){
            private IContext context;

            @Override
            public IContext getContext() {
                return this.context;
            }

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (node == target) {
                    this.context = (IContext)this.contextStack.peek();
                    return false;
                }
                return this.context == null;
            }
        };
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getContext();
    }

    public static IContext findContext(ISourceModule sourceModule, ModuleDeclaration unit, final int offset) {
        ContextFinder visitor = new ContextFinder(sourceModule){
            private IContext context;

            @Override
            public IContext getContext() {
                return this.context;
            }

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (!(node instanceof ASTError) && node.sourceStart() <= offset && node.sourceEnd() >= offset && !this.contextStack.isEmpty()) {
                    this.context = (IContext)this.contextStack.peek();
                }
                return node.sourceEnd() >= offset && node.sourceStart() <= offset;
            }
        };
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        if (visitor.getContext() == null) {
            Logger.log(202, "Context is null");
            return new FileContext(sourceModule, unit, offset);
        }
        return visitor.getContext();
    }

    public static Declaration findDeclarationAfterPHPdoc(ModuleDeclaration moduleDeclaration, final int offset) {
        final Declaration[] decl = new Declaration[1];
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visit(MethodDeclaration m) {
                if (!this.found && m.sourceStart() > offset) {
                    decl[0] = m;
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visit(TypeDeclaration t) {
                if (!this.found && t.sourceStart() > offset) {
                    decl[0] = t;
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visit(Statement s) throws Exception {
                if (s.getKind() == 25 && !this.found && s.sourceStart() > offset) {
                    decl[0] = (Declaration)s;
                    this.found = true;
                    return false;
                }
                return super.visit(s);
            }

            public boolean visitGeneral(ASTNode n) {
                if (!this.found && n.sourceStart() > offset) {
                    this.found = true;
                    return false;
                }
                return !this.found;
            }
        };
        try {
            moduleDeclaration.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return decl[0];
    }

    public static FieldDeclaration getConstantDeclaration(CallExpression callExpression) {
        ASTNode argument;
        CallArgumentsList args;
        String name = callExpression.getName();
        if ("define".equalsIgnoreCase(name) && (args = callExpression.getArgs()) != null && args.getChilds() != null && !args.getChilds().isEmpty() && (argument = (ASTNode)args.getChilds().get(0)) instanceof Scalar) {
            String constant = ASTUtils.stripQuotes(((Scalar)argument).getValue());
            FieldDeclaration fieldDeclaration = new FieldDeclaration(constant, argument.sourceStart(), argument.sourceEnd(), callExpression.sourceStart(), callExpression.sourceEnd());
            fieldDeclaration.setModifier(8198);
            return fieldDeclaration;
        }
        return null;
    }

    public static UsePart findUseStatementByAlias(ModuleDeclaration moduleDeclaration, String aliasName, int offset) {
        FindUseStatementByAliasASTVisitor visitor = new FindUseStatementByAliasASTVisitor(aliasName, offset);
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getResult();
    }

    public static UsePart findUseStatementByNamespace(ModuleDeclaration moduleDeclaration, String namespace, int offset) {
        FindUseStatementByNamespaceASTVisitor visitor = new FindUseStatementByNamespaceASTVisitor(namespace, offset);
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getResult();
    }

    public static UseStatement[] getUseStatements(ModuleDeclaration moduleDeclaration, int offset) {
        GetUseStatementsASTVisitor visitor = new GetUseStatementsASTVisitor(offset);
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getResult();
    }
}

