/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

@Deprecated
public class IntList
implements Cloneable {
    private int minimumSize;
    private int[] data;
    private int size;

    public IntList() {
        this(5);
    }

    public IntList(int size) {
        this.data = new int[size];
        this.minimumSize = size;
        this.size = -1;
    }

    public IntList(int[] data) {
        this.data = data;
        this.minimumSize = data.length;
        this.size = data.length;
    }

    public boolean isEmpty() {
        return this.size == -1;
    }

    public int top() {
        return this.data[this.size];
    }

    public int popStack() {
        int result = this.data[this.size];
        --this.size;
        this.reductListSize();
        return result;
    }

    public int remove(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + index);
        }
        int result = this.data[index];
        int i = index;
        while (i < this.size) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.size;
        this.reductListSize();
        return result;
    }

    public void pushStack(int val) {
        ++this.size;
        this.verifySizeBeforeAdding();
        this.data[this.size] = val;
    }

    public void add(int index, int val) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + index);
        }
        ++this.size;
        this.verifySizeBeforeAdding();
        int i = this.size;
        while (i > index) {
            this.data[i] = this.data[i - 1];
            --i;
        }
        this.data[index] = val;
    }

    public void add(int val) {
        this.pushStack(val);
    }

    public int get(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + index);
        }
        return this.data[index];
    }

    public int clear() {
        this.size = -1;
        return -1;
    }

    public int size() {
        return this.size + 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IntList)) {
            return false;
        }
        IntList s2 = (IntList)obj;
        if (this.size != s2.size) {
            return false;
        }
        int i = this.size;
        while (i >= 0) {
            if (this.data[i] != s2.data[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void verifySizeBeforeAdding() {
        int length = this.data.length;
        if (this.size == this.data.length) {
            int[] temp = new int[length * 2];
            System.arraycopy(this.data, 0, temp, 0, length);
            this.data = temp;
        }
    }

    private void reductListSize() {
        if (this.size / 4 < this.data.length) {
            int newSize = Math.max(this.size / 2, this.minimumSize);
            int[] temp = new int[newSize];
            System.arraycopy(this.data, 0, temp, 0, this.size + 1);
            this.data = temp;
        }
    }

    public void copyFrom(IntList s) {
        this.size = s.size;
        int i = 0;
        while (i <= s.size) {
            this.add(s.data[i]);
            ++i;
        }
    }

    public boolean contains(int val) {
        int i = 0;
        while (i <= this.size) {
            if (this.data[i] == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        int i = 0;
        while (i <= this.size) {
            sb.append(" stack[" + i + "]= " + this.data[i]);
            ++i;
        }
        return sb.toString();
    }

    public Object clone() {
        IntList rv = new IntList(this.size());
        rv.copyFrom(this);
        return rv;
    }

    public int[] toIntArray() {
        int[] rv = new int[this.size()];
        return this.toIntArray(rv);
    }

    public int[] toIntArray(int[] array) {
        int i = 0;
        while (i <= this.size) {
            array[i] = this.data[i];
            ++i;
        }
        return array;
    }

    public static Iterator createIterator() {
        return new Iterator();
    }

    public void startIterating(Iterator i) {
        i.lastIndex = this.size;
    }

    public boolean hasNext(Iterator i) {
        return i.lastIndex != -1;
    }

    public int next(Iterator i) {
        return this.data[i.lastIndex--];
    }

    public static class Iterator {
        int lastIndex = -1;
    }
}

