/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;

public class PHPProjectPreferences {
    public static String getPreferenceNodeQualifier() {
        return "org.eclipse.php.debug.core.Debug_Process_Preferences";
    }

    public static IScopeContext getProjectScope(IProject project) {
        return new ProjectScope(project);
    }

    public static boolean getElementSettingsForProject(IProject project) {
        IScopeContext pScope = PHPProjectPreferences.getProjectScope(project);
        return pScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).getBoolean(PHPProjectPreferences.getProjectSettingsKey(), false);
    }

    public static String getProjectSettingsKey() {
        return "org.eclipse.php.debug.core.use-project-settings";
    }

    public static boolean getStopAtFirstLine(IProject project) {
        boolean stop = Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, true, null);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            stop = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, stop);
        }
        return stop;
    }

    public static boolean isSortByName() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.SORT_BY_NAME, true, null);
    }

    public static void changeSortByNameStatus() {
        PHPDebugPlugin.getInstancePreferences().putBoolean(PHPDebugCorePreferenceNames.SORT_BY_NAME, !Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.SORT_BY_NAME, true, null));
    }

    public static String getDefaultBasePath(IProject project) {
        String basePath = null;
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            basePath = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get("DefaultProjectBasePath", basePath);
        }
        if (project != null && basePath == null) {
            basePath = String.valueOf('/') + project.getName();
        }
        if (basePath != null && !basePath.startsWith("/")) {
            basePath = String.valueOf('/') + basePath;
        }
        return basePath;
    }

    public static void setDefaultBasePath(IProject project, String basePath) {
        if (basePath != null && !basePath.startsWith("/")) {
            basePath = String.valueOf('/') + basePath;
        }
        PHPDebugPlugin.getInstancePreferences().put("DefaultProjectBasePath", basePath);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).put("DefaultProjectBasePath", basePath);
        }
    }

    public static String getDefaultServerName(IProject project) {
        String serverName = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", "defaultPHPServer", null, null);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            serverName = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get("defaultPHPServer", serverName);
        }
        return serverName;
    }

    public static String getDefaultDebuggerID(IProject project) {
        String debuggerID = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, null, null);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            debuggerID = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        }
        return debuggerID;
    }

    public static String getTransferEncoding(IProject project) {
        String encoding = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.TRANSFER_ENCODING, null, null);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            encoding = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, encoding);
        }
        return encoding;
    }

    public static String getOutputEncoding(IProject project) {
        String encoding = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.OUTPUT_ENCODING, null, null);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            encoding = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, encoding);
        }
        return encoding;
    }
}

