/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;

class DBGpUninitVariable
extends DBGpElement
implements IVariable,
IVariableFacet {
    private DBGpUninitValue fValue;
    protected final Set<IVariableFacet.Facet> fFacets = new HashSet<IVariableFacet.Facet>();

    public DBGpUninitVariable(IDebugTarget target) {
        super(target);
        this.fValue = new DBGpUninitValue(target);
        this.addFacets(IVariableFacet.Facet.VIRTUAL_UNINIT);
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        return IPHPDataType.DataType.PHP_UNINITIALIZED.getText();
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    @Override
    public boolean hasFacet(IVariableFacet.Facet facet) {
        return this.fFacets.contains((Object)facet);
    }

    @Override
    public void addFacets(IVariableFacet.Facet ... facets) {
        IVariableFacet.Facet[] facetArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableFacet.Facet facet = facetArray[n2];
            this.fFacets.add(facet);
            ++n2;
        }
    }

    protected class DBGpUninitValue
    extends DBGpElement
    implements IValue {
        public DBGpUninitValue(IDebugTarget target) {
            super(target);
        }

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public String getValueString() throws DebugException {
            return null;
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }

        public IVariable[] getVariables() throws DebugException {
            return new IVariable[0];
        }

        public boolean hasVariables() throws DebugException {
            return false;
        }
    }
}

