/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.ui.launching.AbstractDebugWebLaunchSettingsSection;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationDebuggerTab;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ZendDebuggerWebLaunchSettingsSection
extends AbstractDebugWebLaunchSettingsSection {
    private Group browserGroup;
    private Button openBrowser;
    private Composite sessionGroup;
    private Button debugAllPagesBt;
    private Button debugFirstPageBt;
    private Button debugStartFromBt;
    private Text debugFromTxt;
    private Button resetBt;
    private Button debugContinueBt;

    @Override
    public void createSection(Composite parent, AbstractPHPLaunchConfigurationDebuggerTab.WidgetListener widgetListener) {
        super.createSection(parent, widgetListener);
        this.createBrowserGroup(parent);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        super.initialize(configuration);
        try {
            boolean isOpenInBrowser = configuration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowser.setSelection(isOpenInBrowser);
            String debugSetting = configuration.getAttribute("debugPages", "debugAllPages");
            if ("debugAllPages".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(true);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFirstPage".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(true);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFrom".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(true);
                boolean shouldContinue = configuration.getAttribute("debugFromURL", false);
                this.debugContinueBt.setSelection(shouldContinue);
            }
            String startFromURL = configuration.getAttribute("debugContinue", "");
            this.debugFromTxt.setText(startFromURL);
            this.updateDebugFrom();
            this.enableSessionSettingButtons(isOpenInBrowser);
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        boolean isOpenInBrowser = this.openBrowser.getSelection();
        configuration.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", isOpenInBrowser);
        if (isOpenInBrowser) {
            if (this.debugAllPagesBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugAllPages");
            } else if (this.debugFirstPageBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugFirstPage");
            } else {
                configuration.setAttribute("debugPages", "debugFrom");
                configuration.setAttribute("debugContinue", this.debugFromTxt.getText());
                configuration.setAttribute("debugFromURL", this.debugContinueBt.getSelection());
            }
        } else {
            configuration.setAttribute("debugPages", "debugFirstPage");
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("debugPages", "debugAllPages");
    }

    @Override
    public AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage isValid(ILaunchConfiguration configuration) {
        AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage status = super.isValid(configuration);
        if (status.getMessageType() == 3) {
            return status;
        }
        if (this.debugStartFromBt.getSelection()) {
            if (this.debugFromTxt.getText().trim().equals("")) {
                return new AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage(3, Messages.ZendDebuggerWebLaunchSettingsSection_Invalid_debug_start_page);
            }
            try {
                new URL(this.debugFromTxt.getText());
            }
            catch (MalformedURLException malformedURLException) {
                return new AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage(3, Messages.ZendDebuggerWebLaunchSettingsSection_Invalid_URL);
            }
        }
        return status;
    }

    protected void createBrowserGroup(Composite parent) {
        this.browserGroup = new Group(parent, 0);
        this.browserGroup.setLayout((Layout)new GridLayout(1, false));
        this.browserGroup.setLayoutData((Object)new GridData(768));
        this.browserGroup.setText(Messages.ZendDebuggerWebLaunchSettingsSection_Browser);
        this.openBrowser = new Button((Composite)this.browserGroup, 32);
        this.openBrowser.setText(Messages.ZendDebuggerWebLaunchSettingsSection_Open_in_browser);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.openBrowser.setLayoutData((Object)data);
        this.sessionGroup = new Composite((Composite)this.browserGroup, 0);
        this.sessionGroup.setLayout((Layout)new GridLayout(3, false));
        this.sessionGroup.setLayoutData((Object)new GridData(768));
        this.openBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                boolean isOpenInBrowser = b.getSelection();
                if (!isOpenInBrowser) {
                    ZendDebuggerWebLaunchSettingsSection.this.debugFirstPageBt.setSelection(true);
                    ZendDebuggerWebLaunchSettingsSection.this.debugAllPagesBt.setSelection(false);
                } else {
                    ZendDebuggerWebLaunchSettingsSection.this.debugFirstPageBt.setSelection(false);
                    ZendDebuggerWebLaunchSettingsSection.this.debugAllPagesBt.setSelection(true);
                }
                ZendDebuggerWebLaunchSettingsSection.this.debugStartFromBt.setSelection(false);
                ZendDebuggerWebLaunchSettingsSection.this.debugContinueBt.setSelection(false);
                ZendDebuggerWebLaunchSettingsSection.this.enableSessionSettingButtons(isOpenInBrowser);
            }
        });
        this.debugAllPagesBt = SWTFactory.createRadioButton((Composite)this.sessionGroup, (String)Messages.ZendDebuggerWebLaunchSettingsSection_Debug_all_pages);
        data = (GridData)this.debugAllPagesBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugFirstPageBt = SWTFactory.createRadioButton((Composite)this.sessionGroup, (String)Messages.ZendDebuggerWebLaunchSettingsSection_Debug_first_page);
        data = (GridData)this.debugFirstPageBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugStartFromBt = SWTFactory.createRadioButton((Composite)this.sessionGroup, (String)Messages.ZendDebuggerWebLaunchSettingsSection_Start_debug_from);
        data = (GridData)this.debugStartFromBt.getLayoutData();
        data.horizontalIndent = 20;
        this.debugFromTxt = new Text(this.sessionGroup, 2052);
        this.debugFromTxt.setLayoutData((Object)new GridData(768));
        this.resetBt = SWTFactory.createPushButton((Composite)this.sessionGroup, (String)Messages.ZendDebuggerWebLaunchSettingsSection_Default, null);
        this.resetBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ZendDebuggerWebLaunchSettingsSection.this.getConfiguration() != null) {
                    try {
                        ZendDebuggerWebLaunchSettingsSection.this.debugFromTxt.setText(ZendDebuggerWebLaunchSettingsSection.this.getConfiguration().getAttribute("base_url", ""));
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.debugContinueBt = SWTFactory.createCheckButton((Composite)this.sessionGroup, (String)Messages.ZendDebuggerWebLaunchSettingsSection_Continue_debug_from, null, (boolean)false, (int)1);
        data = (GridData)this.debugContinueBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 40;
        this.debugStartFromBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendDebuggerWebLaunchSettingsSection.this.updateDebugFrom();
            }
        });
        this.updateDebugFrom();
        this.openBrowser.addSelectionListener((SelectionListener)this.widgetListener);
        this.debugFirstPageBt.addSelectionListener((SelectionListener)this.widgetListener);
        this.debugAllPagesBt.addSelectionListener((SelectionListener)this.widgetListener);
        this.debugContinueBt.addSelectionListener((SelectionListener)this.widgetListener);
        this.debugStartFromBt.addSelectionListener((SelectionListener)this.widgetListener);
        this.debugFromTxt.addModifyListener((ModifyListener)this.widgetListener);
    }

    private void enableSessionSettingButtons(boolean isOpenInBrowser) {
        this.debugFirstPageBt.setEnabled(isOpenInBrowser);
        this.debugAllPagesBt.setEnabled(isOpenInBrowser);
        this.debugStartFromBt.setEnabled(isOpenInBrowser);
        this.debugContinueBt.setEnabled(false);
        this.resetBt.setEnabled(false);
        this.debugFromTxt.setEnabled(false);
    }

    private void updateDebugFrom() {
        if (this.getConfiguration() != null && this.debugFromTxt.getText().trim().equals("")) {
            try {
                this.debugFromTxt.setText(this.getConfiguration().getAttribute("base_url", ""));
            }
            catch (CoreException coreException) {}
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean debugFromSelected = ZendDebuggerWebLaunchSettingsSection.this.debugStartFromBt.getSelection();
                    ZendDebuggerWebLaunchSettingsSection.this.debugFromTxt.setEnabled(debugFromSelected);
                    ZendDebuggerWebLaunchSettingsSection.this.debugContinueBt.setEnabled(debugFromSelected);
                    ZendDebuggerWebLaunchSettingsSection.this.resetBt.setEnabled(debugFromSelected);
                }
                catch (SWTException sWTException) {}
            }
        });
    }
}

