/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.visitor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.refactoring.core.SourceModuleSourceContext;
import org.eclipse.php.refactoring.core.visitor.StatementAnalyzer;

public class CodeAnalyzer
extends StatementAnalyzer {
    private ISourceModule sourceModule;

    public CodeAnalyzer(Program cunit, ISourceModule sourceModule, IDocument document, Selection selection, boolean traverseSelectedNode) throws CoreException, IOException {
        super(cunit, sourceModule, document, selection, traverseSelectedNode);
        this.sourceModule = sourceModule;
    }

    @Override
    protected final void checkSelectedNodes() {
        super.checkSelectedNodes();
        RefactoringStatus status = this.getStatus();
        if (status.hasFatalError()) {
            return;
        }
        ASTNode node = this.getFirstSelectedNode();
        if (node instanceof SingleFieldDeclaration) {
            status.addFatalError("Operation not applicable to the current selection.", (RefactoringStatusContext)new SourceModuleSourceContext(this.sourceModule, (ISourceRange)new SourceRange(node.getStart(), node.getLength())));
        }
    }
}

