/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.PHPSelectionUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
    }

    public OpenCallHierarchyAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(final ITextSelection selection) {
        IJobManager jobManager = Job.getJobManager();
        if (jobManager.find((Object)PHPUiPlugin.OPEN_CALL_HIERARCHY_ACTION_FAMILY_NAME).length > 0) {
            jobManager.cancel((Object)PHPUiPlugin.OPEN_CALL_HIERARCHY_ACTION_FAMILY_NAME);
        }
        Job job = new Job(PHPUiPlugin.OPEN_CALL_HIERARCHY_ACTION_FAMILY_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                OpenCallHierarchyAction.this.setEnabled(OpenCallHierarchyAction.this.isEnabled(selection));
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return this.getName().equals(family);
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IModelElement.class);
        }
        if (!(input instanceof IModelElement)) {
            return false;
        }
        switch (((IModelElement)input).getElementType()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    private boolean isEnabled(ITextSelection selection) {
        if (this.fEditor == null || selection == null) {
            return false;
        }
        if (this.fEditor.getModelElement() instanceof ISourceModule) {
            ISourceModule sourceModule = (ISourceModule)this.fEditor.getModelElement();
            IModelElement element = PHPSelectionUtil.getSelectionModelElement(selection.getOffset(), selection.getLength(), sourceModule);
            if (element == null) {
                return false;
            }
            switch (element.getElementType()) {
                case 9: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ISourceModule input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)input)) {
            return;
        }
        try {
            IModelElement enclosingMethod;
            IModelElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IModelElement> candidates = new ArrayList<IModelElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IModelElement[] resolvedElements = CallHierarchyUI.getCandidates((Object)elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod((IModelElement)input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            this.run(candidates.toArray(new IModelElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)"");
        }
        catch (InterruptedException interruptedException) {}
    }

    private IModelElement getEnclosingMethod(IModelElement input, ITextSelection selection) {
        IModelElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 5: {
                    ISourceModule cu = (ISourceModule)input.getAncestor(5);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 9) {
                return enclosingElement;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            if (selection.size() != 1) {
                return;
            }
            Object input = selection.getFirstElement();
            if (!(input instanceof IModelElement)) {
                IStatus status = OpenCallHierarchyAction.createStatus(Messages.OpenCallHierarchyAction_0);
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)"", (IStatus)status);
                return;
            }
            IModelElement element = (IModelElement)input;
            if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)element)) {
                return;
            }
            ArrayList<IModelElement> result = new ArrayList<IModelElement>(1);
            IStatus status = OpenCallHierarchyAction.compileCandidates(result, element);
            if (status.isOK()) {
                this.run(result.toArray(new IModelElement[result.size()]));
            } else {
                this.openErrorDialog(status);
            }
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = "";
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return "";
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open((IModelElement[])elements, (IWorkbenchWindow)this.getSite().getWorkbenchWindow(), (String)this.getCallHierarchyID());
    }

    private static IStatus compileCandidates(List<IModelElement> result, IModelElement elem) {
        Status ok = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 9: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus("");
    }

    private static IStatus createStatus(String message) {
        return new Status(1, DLTKUIPlugin.getPluginId(), 10001, message, null);
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }
}

