/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ITypeHierarchyChangedListener;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.php.internal.core.PHPToolkitUtil;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 8;
    private static ArrayList fgHierarchyCache = new ArrayList(8);
    private static Map fgMethodOverrideTesterCache = new LRUMap(8);
    private static int fgCacheHits = 0;
    private static int fgCacheMisses = 0;

    public static ITypeHierarchy getTypeHierarchy(IType type) throws ModelException {
        return SuperTypeHierarchyCache.getTypeHierarchy(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodOverrideTester getMethodOverrideTester(IType type) throws ModelException {
        MethodOverrideTester test = null;
        Map map = fgMethodOverrideTesterCache;
        synchronized (map) {
            test = (MethodOverrideTester)fgMethodOverrideTesterCache.get(type);
        }
        if (test == null) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
            Map map2 = fgMethodOverrideTesterCache;
            synchronized (map2) {
                test = (MethodOverrideTester)fgMethodOverrideTesterCache.get(type);
                if (test == null) {
                    test = new MethodOverrideTester(type, hierarchy);
                    fgMethodOverrideTesterCache.put(type, test);
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMethodOverrideTester(ITypeHierarchy hierarchy) {
        Map map = fgMethodOverrideTesterCache;
        synchronized (map) {
            Iterator iter = fgMethodOverrideTesterCache.values().iterator();
            while (iter.hasNext()) {
                MethodOverrideTester curr = (MethodOverrideTester)iter.next();
                if (curr == null || curr.getTypeHierarchy() == null || !curr.getTypeHierarchy().equals(hierarchy)) continue;
                iter.remove();
            }
        }
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor progressMonitor) throws ModelException {
        if (type == null || !type.exists() || !PHPToolkitUtil.isFromPhpProject((IType)type)) {
            return new FakeTypeHierarchy();
        }
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(type);
        if (hierarchy == null) {
            ++fgCacheMisses;
            hierarchy = type.newSupertypeHierarchy(progressMonitor);
            SuperTypeHierarchyCache.addTypeHierarchyToCache(hierarchy);
        } else {
            ++fgCacheHits;
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyToCache(ITypeHierarchy hierarchy) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            int nEntries = fgHierarchyCache.size();
            if (nEntries >= 8) {
                HierarchyCacheEntry oldest = null;
                ArrayList<HierarchyCacheEntry> obsoleteHierarchies = new ArrayList<HierarchyCacheEntry>(8);
                int i = 0;
                while (i < nEntries) {
                    HierarchyCacheEntry entry = (HierarchyCacheEntry)fgHierarchyCache.get(i);
                    ITypeHierarchy curr = entry.getTypeHierarchy();
                    if (!curr.exists() || hierarchy.contains(curr.getType())) {
                        obsoleteHierarchies.add(entry);
                    } else if (oldest == null || entry.getLastAccess() < oldest.getLastAccess()) {
                        oldest = entry;
                    }
                    ++i;
                }
                if (!obsoleteHierarchies.isEmpty()) {
                    i = 0;
                    while (i < obsoleteHierarchies.size()) {
                        SuperTypeHierarchyCache.removeHierarchyEntryFromCache((HierarchyCacheEntry)obsoleteHierarchies.get(i));
                        ++i;
                    }
                } else if (oldest != null) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(oldest);
                }
            }
            HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy);
            fgHierarchyCache.add(newEntry);
        }
    }

    public static boolean hasInCache(IType type) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITypeHierarchy findTypeHierarchyInCache(IType type) {
        if (type != null) {
            ArrayList arrayList = fgHierarchyCache;
            synchronized (arrayList) {
                int i = fgHierarchyCache.size() - 1;
                while (i >= 0) {
                    HierarchyCacheEntry curr = (HierarchyCacheEntry)fgHierarchyCache.get(i);
                    ITypeHierarchy hierarchy = curr.getTypeHierarchy();
                    if (!hierarchy.exists()) {
                        SuperTypeHierarchyCache.removeHierarchyEntryFromCache(curr);
                    } else if (hierarchy.contains(type)) {
                        curr.markAsAccessed();
                        return hierarchy;
                    }
                    --i;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeHierarchyEntryFromCache(HierarchyCacheEntry entry) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            SuperTypeHierarchyCache.removeMethodOverrideTester(entry.getTypeHierarchy());
            entry.dispose();
            fgHierarchyCache.remove(entry);
        }
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    private static class FakeTypeHierarchy
    extends TypeHierarchy {
        public FakeTypeHierarchy() {
            this.initialize(1);
        }
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy fTypeHierarchy;
        private long fLastAccess;

        public HierarchyCacheEntry(ITypeHierarchy hierarchy) {
            this.fTypeHierarchy = hierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.markAsAccessed();
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            SuperTypeHierarchyCache.removeHierarchyEntryFromCache(this);
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void markAsAccessed() {
            this.fLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.fLastAccess;
        }

        public void dispose() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.fTypeHierarchy = null;
        }

        public String toString() {
            return "Super hierarchy of: " + this.fTypeHierarchy.getType().getElementName();
        }
    }

    public static class LRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public LRUMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.fMaxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }
}

