/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.visitor.HierarchicalVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.corext.fix.LinkedProposalModel;
import org.eclipse.php.internal.ui.editor.contentassist.Messages;
import org.eclipse.php.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.text.edits.TextEditGroup;

public class AssignToLocalCompletionProposal
extends ASTRewriteCorrectionProposal {
    public static final String COMMAND_ID = "org.eclipse.php.internal.ui.assignToLocal.assist";
    public static final String KEY_NAME = "name";
    public static final String DEFAULT_NAME = "localVar";
    protected ASTNode context;

    public AssignToLocalCompletionProposal(ISourceModule cu, ASTNode context) {
        super(Messages.AssignToLocalCompletionProposal_name, cu, (ASTRewrite)null, 0, PHPPluginImages.DESC_FIELD_DEFAULT.createImage());
        this.context = context;
        this.setCommandId(COMMAND_ID);
    }

    public static ExpressionStatement getStatement(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ExpressionStatement) {
            return (ExpressionStatement)node;
        }
        return node.getParent() == null ? null : AssignToLocalCompletionProposal.getStatement(node.getParent());
    }

    public static Expression getMainExpression(ASTNode node) {
        ExpressionStatement statement = AssignToLocalCompletionProposal.getStatement(node);
        return statement == null || statement.getExpression() == null ? null : statement.getExpression();
    }

    public static boolean isEnd(ASTNode coveringNode) {
        return coveringNode instanceof ExpressionStatement;
    }

    public static boolean isFunctionCall(ASTNode coveringNode) {
        if (coveringNode instanceof FunctionInvocation) {
            return true;
        }
        return AssignToLocalCompletionProposal.isEnd(coveringNode) || coveringNode.getParent() == null ? false : AssignToLocalCompletionProposal.isFunctionCall(coveringNode.getParent());
    }

    public static boolean isAssigned(ASTNode coveringNode) {
        if (coveringNode instanceof Assignment) {
            return true;
        }
        return AssignToLocalCompletionProposal.isEnd(coveringNode) || coveringNode.getParent() == null ? false : AssignToLocalCompletionProposal.isAssigned(coveringNode.getParent());
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        LinkedProposalModel linkedModel = this.getLinkedProposalModel();
        TextEditGroup editGroup = new TextEditGroup(COMMAND_ID);
        ExpressionStatement statement = AssignToLocalCompletionProposal.getStatement(this.context);
        Expression expression = statement.getExpression();
        AST ast = statement.getAST();
        ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
        String[] names = this.possibleNames((ASTNode)expression);
        int i = 0;
        while (i < names.length) {
            linkedModel.getPositionGroup(KEY_NAME, true).addProposal(names[0], null, 10);
            ++i;
        }
        Variable variable = ast.newVariable(names[0]);
        Assignment assign = ast.newAssignment((VariableBase)variable, 0, (Expression)astRewrite.createCopyTarget((ASTNode)expression));
        astRewrite.replace((ASTNode)expression, (ASTNode)assign, editGroup);
        linkedModel.getPositionGroup(KEY_NAME, true).addPosition(astRewrite.track((ASTNode)variable.getName()), true);
        linkedModel.setEndPosition(astRewrite.track((ASTNode)statement));
        return astRewrite;
    }

    protected String[] possibleNames(ASTNode node) {
        FindVariableVisitor find;
        String basic = this.getBasicName(node);
        if (basic == null || basic.length() < 1) {
            basic = DEFAULT_NAME;
        }
        if (basic.charAt(0) == '\\') {
            basic = basic.substring(1);
        }
        basic = String.valueOf(Character.toLowerCase(basic.charAt(0))) + basic.substring(1);
        ASTNode scope = this.searchScope(node);
        int num = -1;
        do {
            find = new FindVariableVisitor(++num == 0 ? basic : String.valueOf(basic) + num);
            scope.childrenAccept((Visitor)find);
        } while (find.found);
        return new String[]{find.search};
    }

    private ASTNode searchScope(ASTNode node) {
        if (node.getParent() == null) {
            return node.getRoot();
        }
        if (node.getParent() instanceof FunctionDeclaration) {
            return node.getParent();
        }
        return this.searchScope(node.getParent());
    }

    private String getBasicName(ASTNode node) {
        if (node != null) {
            switch (node.getType()) {
                case 43: {
                    MethodInvocation inv = (MethodInvocation)node;
                    return this.getBasicName((ASTNode)inv.getMethod());
                }
                case 30: {
                    FunctionInvocation func = (FunctionInvocation)node;
                    if (func.getFunctionName() == null || func.getFunctionName().getName() == null) {
                        return DEFAULT_NAME;
                    }
                    return this.getBasicName((ASTNode)func.getFunctionName().getName());
                }
                case 53: {
                    StaticMethodInvocation st = (StaticMethodInvocation)node;
                    return this.getBasicName((ASTNode)st.getMethod());
                }
                case 13: {
                    ClassInstanceCreation ci = (ClassInstanceCreation)node;
                    if (ci.getClassName() != null) {
                        return this.getBasicName((ASTNode)ci.getClassName().getName());
                    }
                }
                case 60: {
                    return this.getBasicName((ASTNode)((Variable)node).getName());
                }
                case 0: {
                    return this.getBasicName((ASTNode)((ArrayAccess)node).getName());
                }
                case 33: 
                case 65: {
                    return ((Identifier)node).getName();
                }
            }
        }
        return DEFAULT_NAME;
    }

    private class FindVariableVisitor
    extends HierarchicalVisitor {
        public boolean found = false;
        public String search;

        public FindVariableVisitor(String search) {
            this.search = search;
        }

        public boolean visit(ASTNode node) {
            return !this.found && super.visit(node);
        }

        public boolean visit(FunctionDeclaration node) {
            return false;
        }

        public boolean visit(MethodDeclaration method) {
            return false;
        }

        public boolean visit(Variable var) {
            String name;
            if (var.isDollared() && var.getName() instanceof Identifier && (name = ((Identifier)var.getName()).getName()) != null && name.equals(this.search)) {
                this.found = true;
                return false;
            }
            return super.visit(var);
        }
    }
}

