/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.folding.html.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.projection.XMLCommentFoldingPosition;
import org.eclipse.wst.xml.ui.internal.projection.XMLElementFoldingPosition;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterHTML
implements INodeAdapter {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.html.ui/projectionperf"));
    ProjectionModelNodeAdapterFactoryHTML fAdapterFactory;
    private Map fTagAnnotations = new HashMap();

    public ProjectionModelNodeAdapterHTML(ProjectionModelNodeAdapterFactoryHTML factory) {
        this.fAdapterFactory = factory;
    }

    private Position createProjectionPosition(Node node) {
        IndexedRegion inode;
        XMLElementFoldingPosition pos = null;
        if (this.fAdapterFactory.isNodeProjectable(node) && node instanceof IndexedRegion && (inode = (IndexedRegion)node).getStartOffset() >= 0 && inode.getLength() >= 0) {
            IDOMNode node1 = (IDOMNode)inode;
            IStructuredDocumentRegion startRegion = node1.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion endRegion = node1.getEndStructuredDocumentRegion();
            if (startRegion != null && endRegion != null) {
                pos = new XMLElementFoldingPosition(startRegion, endRegion);
            } else if (startRegion != null && node instanceof CommentImpl) {
                pos = new XMLCommentFoldingPosition(startRegion);
            }
        }
        return pos;
    }

    private TagProjectionAnnotation getExistingAnnotation(Node node) {
        TagProjectionAnnotation anno = null;
        if (node != null && !this.fTagAnnotations.isEmpty()) {
            Iterator it = this.fTagAnnotations.keySet().iterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)((Object)it.next());
                Node n = a.getNode();
                if (!node.equals(n)) continue;
                anno = a;
            }
        }
        return anno;
    }

    public boolean isAdapterForType(Object type) {
        return type == ProjectionModelNodeAdapterHTML.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (!this.fAdapterFactory.isActive()) {
            return;
        }
        if (eventType == 4 && notifier instanceof Node) {
            this.updateAdapter((Node)notifier);
        }
    }

    public void updateAdapter(Node node) {
        this.updateAdapter(node, null);
    }

    void updateAdapter(Node node, ProjectionViewer viewer) {
        long start = System.currentTimeMillis();
        HashMap<TagProjectionAnnotation, Position> additions = new HashMap<TagProjectionAnnotation, Position>();
        HashMap<TagProjectionAnnotation, Position> projectionAnnotations = new HashMap<TagProjectionAnnotation, Position>();
        if (node != null) {
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                Position newPos = this.createProjectionPosition(childNode);
                if (newPos != null) {
                    TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation(childNode, false);
                    TagProjectionAnnotation existing = this.getExistingAnnotation(childNode);
                    if (existing == null) {
                        projectionAnnotations.put(newAnnotation, newPos);
                        additions.put(newAnnotation, newPos);
                    } else {
                        projectionAnnotations.put(existing, newPos);
                        this.fTagAnnotations.remove((Object)existing);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            ProjectionAnnotation[] oldList = null;
            if (!this.fTagAnnotations.isEmpty()) {
                oldList = this.fTagAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            ProjectionAnnotation[] modifyList = null;
            if (!projectionAnnotations.isEmpty()) {
                modifyList = projectionAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            if (viewer != null && !projectionAnnotations.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, projectionAnnotations, null, viewer);
            }
            if (oldList != null && oldList.length > 0 || !additions.isEmpty() || modifyList != null && modifyList.length > 0) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])oldList, additions, (Annotation[])modifyList);
            }
        }
        this.fTagAnnotations = projectionAnnotations;
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            String nodeName = node != null ? node.getNodeName() : "null";
            System.out.println("ProjectionModelNodeAdapterHTML.updateAdapter (" + nodeName + "):" + (end - start));
        }
    }

    private class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible;
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean isCollapsed) {
            super(isCollapsed);
            this.fIsVisible = false;
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void setNode(Node node) {
            this.fNode = node;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

