/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.Messages;

public class ProblemLocation
implements IProblemLocation {
    private final IProblemIdentifier fIdentifier;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, IScriptAnnotation annotation) {
        this.fIdentifier = annotation.getId();
        this.fArguments = annotation.getArguments();
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.eclipse.dltk.ui.error".equals(annotation.getType());
        String markerType = annotation.getMarkerType();
        this.fMarkerType = markerType != null ? markerType : "org.eclipse.dltk.core.problem";
    }

    public ProblemLocation(int offset, int length, IProblemIdentifier id, String[] arguments, boolean isError, String markerType) {
        this.fIdentifier = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fIdentifier = problem.getID();
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = problem.getID() instanceof IProblemIdentifierExtension ? ((IProblemIdentifierExtension)problem.getID()).getMarkerType() : (problem instanceof CategorizedProblem ? ((CategorizedProblem)problem).getMarkerType() : "org.eclipse.dltk.core.problem");
    }

    @Override
    public IProblemIdentifier getProblemIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public String[] getProblemArguments() {
        return this.fArguments;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public boolean isError() {
        return this.fIsError;
    }

    @Override
    public String getMarkerType() {
        return this.fMarkerType;
    }

    @Override
    public ASTNode getCoveringNode(Program astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((Visitor)finder);
        return finder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode(Program astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((Visitor)finder);
        return finder.getCoveredNode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Messages.ProblemLocation_0).append(DefaultProblemIdentifier.encode((IProblemIdentifier)this.fIdentifier)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] arg = this.fArguments;
        if (arg != null) {
            int i = 0;
            while (i < arg.length) {
                buf.append(arg[i]);
                buf.append('\n');
                ++i;
            }
        }
        return buf.toString();
    }
}

