/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class PHPFileCreationWizardPage
extends WizardNewFileCreationPage {
    public PHPFileCreationWizardPage(ISelection selection) {
        super("PHPWizardNewFileCreationPage", selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null);
        this.setTitle(PHPUIMessages.PHPFileCreationWizardPage_3);
        this.setDescription(PHPUIMessages.PHPFileCreationWizardPage_4);
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_FILE);
    }

    private String computeDefaultFileName() {
        String fileName = this.addDefaultExtension(PHPUIMessages.PHPFileCreationWizardPage_8);
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null) {
            int count = 0;
            while (true) {
                IPath path = containerFullPath.append(fileName);
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                fileName = this.addDefaultExtension(String.valueOf(PHPUIMessages.PHPFileCreationWizardPage_8) + ++count);
            }
        }
        return fileName;
    }

    private String addDefaultExtension(String fName) {
        return String.valueOf(fName) + ".php";
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(this.computeDefaultFileName());
        this.setPageComplete(this.validatePage());
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.creating_a_php_file_within_a_project");
        super.performHelp();
    }

    protected boolean validatePage() {
        IContentType contentType;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        IPath fullPath = this.getContainerFullPath();
        String fileName = this.getFileName();
        if (fullPath == null) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_10);
            return false;
        }
        IContainer containerFolder = this.getContainer(fullPath);
        if (containerFolder == null || !containerFolder.exists()) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_11);
            return false;
        }
        if (!containerFolder.getProject().isOpen()) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_12);
            return false;
        }
        if (fileName == null) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_15);
            return false;
        }
        if (!fileName.equals("") && containerFolder.getFile((IPath)new Path(fileName)).exists()) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_14);
            return false;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (fileName.length() == 0 || dotIndex == 0) {
            this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_15);
            return false;
        }
        if (dotIndex != -1) {
            String fileNameWithoutExtention = fileName.substring(0, dotIndex);
            int i = 0;
            while (i < fileNameWithoutExtention.length()) {
                char ch = fileNameWithoutExtention.charAt(i);
                if (!Character.isJavaIdentifierPart(ch) && ch != '.' && ch != '-') {
                    this.setErrorMessage(PHPUIMessages.PHPFileCreationWizardPage_16);
                    return false;
                }
                ++i;
            }
        }
        if (!(contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP)).isAssociatedWith(fileName)) {
            String[] fileExtensions = contentType.getFileSpecs(8);
            StringBuilder buffer = new StringBuilder(PHPUIMessages.PHPFileCreationWizardPage_17);
            buffer.append(fileExtensions[0]);
            String[] stringArray = fileExtensions;
            int n = fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                buffer.append(", ").append(extension);
                ++n2;
            }
            buffer.append("]");
            this.setErrorMessage(buffer.toString());
            return false;
        }
        return true;
    }

    protected IContainer getContainer(IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return resource instanceof IContainer ? (IContainer)resource : null;
    }

    public IProject getProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(this.getContainerFullPath());
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource != null) {
            project = resource.getProject();
        }
        return project;
    }
}

