/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.internal.debug.core.PDebugUtils;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IPSourceLocator;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PProjectSourceLocation;
import org.eclipse.ptp.internal.debug.core.sourcelookup.SourceLookupFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PSourceLocator
implements IPSourceLocator,
IPersistableSourceLocator,
IResourceChangeListener {
    private static final String SOURCE_LOCATOR_NAME = "pSourceLocator";
    private static final String DISABLED_GENERIC_PROJECT_NAME = "disabledGenericProject";
    private static final String ADDITIONAL_SOURCE_LOCATION_NAME = "additionalSourceLocation";
    private static final String SOURCE_LOCATION_NAME = "cSourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";
    private static final String ATTR_PROJECT_NAME = "projectName";
    private static final String ATTR_DUPLICATE_FILES = "duplicateFiles";
    private IProject fProject = null;
    private IPSourceLocation[] fSourceLocations;
    private List<IProject> fReferencedProjects = new ArrayList<IProject>(10);
    private boolean fDuplicateFiles = false;

    public PSourceLocator(IProject project) {
        this.setProject(project);
        this.setReferencedProjects();
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    @Override
    public boolean contains(IResource resource) {
        IPSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof PProjectSourceLocation && ((PProjectSourceLocation)locations[i]).getProject().equals((Object)resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                Object result;
                block7: {
                    try {
                        result = locations[i].findSourceElement(resource.getLocation().toOSString());
                        if (!(result instanceof IFile) || !((IFile)result).equals((Object)resource)) break block7;
                        return true;
                    }
                    catch (CoreException coreException) {}
                }
                if (result instanceof List && ((List)result).contains(resource)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object findSourceElement(String fileName) {
        Object result = null;
        if (fileName != null && fileName.length() > 0) {
            IPSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException coreException) {}
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getLineNumber(IStackFrame frame) {
        return frame instanceof IPStackFrame ? ((IPStackFrame)frame).getFrameLineNumber() : 0;
    }

    public String getMemento() throws CoreException {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(SOURCE_LOCATOR_NAME);
            document.appendChild(node);
            IPSourceLocation[] locations = this.getSourceLocations();
            this.saveDisabledGenericSourceLocations(locations, document, node);
            this.saveAdditionalSourceLocations(locations, document, node);
            node.setAttribute(ATTR_DUPLICATE_FILES, new Boolean(this.searchForDuplicateFiles()).toString());
            return PDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        this.abort(Messages.PSourceLocator_0, ex);
        return null;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return this.getInput(stackFrame);
    }

    @Override
    public IPSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(SOURCE_LOCATOR_NAME)) {
                this.abort(Messages.PSourceLocator_1, null);
            }
            ArrayList<IPSourceLocation> sourceLocations = new ArrayList<IPSourceLocation>();
            IProject project = this.getProject();
            if (project != null && project.exists() && project.isOpen()) {
                sourceLocations.addAll(Arrays.asList(this.getDefaultSourceLocations()));
            }
            this.removeDisabledLocations(root, sourceLocations);
            this.addAdditionalLocations(root, sourceLocations);
            this.addOldLocations(root, sourceLocations);
            this.setSourceLocations(sourceLocations.toArray(new IPSourceLocation[sourceLocations.size()]));
            this.setSearchForDuplicateFiles(Boolean.valueOf(root.getAttribute(ATTR_DUPLICATE_FILES)));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(Messages.PSourceLocator_2, ex);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        if (event.getSource() instanceof IWorkspace && event.getDelta() != null && (deltas = event.getDelta().getAffectedChildren()) != null) {
            ArrayList<IResource> list = new ArrayList<IResource>(deltas.length);
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getResource() instanceof IProject) {
                    list.add(deltas[i].getResource());
                }
                ++i;
            }
            this.resetSourceLocations(list);
        }
    }

    @Override
    public boolean searchForDuplicateFiles() {
        return this.fDuplicateFiles;
    }

    @Override
    public void setSearchForDuplicateFiles(boolean search) {
        this.fDuplicateFiles = search;
        IPSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            locations[i].setSearchForDuplicateFiles(search);
            ++i;
        }
    }

    @Override
    public void setSourceLocations(IPSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private void addAdditionalLocations(Element root, List<IPSourceLocation> sourceLocations) throws CoreException {
        Bundle bundle = PTPDebugCorePlugin.getDefault().getBundle();
        MultiStatus status = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PSourceLocator_3, null);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block12: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(ADDITIONAL_SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        PTPDebugCorePlugin.log(Messages.PSourceLocator_4);
                    } else {
                        Class clazz = null;
                        try {
                            clazz = bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            PTPDebugCorePlugin.log(NLS.bind((String)Messages.PSourceLocator_5, (Object[])new Object[]{className}));
                            break block12;
                        }
                        IPSourceLocation location = null;
                        try {
                            location = (IPSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            PTPDebugCorePlugin.log(Messages.PSourceLocator_6);
                            break block12;
                        }
                        catch (InstantiationException instantiationException) {
                            PTPDebugCorePlugin.log(Messages.PSourceLocator_6);
                            break block12;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            status.addAll(e.getStatus());
                        }
                    }
                }
            }
            ++i;
        }
        if (status.getSeverity() > 0) {
            throw new CoreException((IStatus)status);
        }
    }

    private void addOldLocations(Element root, List<IPSourceLocation> sourceLocations) throws CoreException {
        Bundle bundle = PTPDebugCorePlugin.getDefault().getBundle();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        PTPDebugCorePlugin.log(Messages.PSourceLocator_4);
                    } else {
                        Class clazz = null;
                        try {
                            clazz = bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            PTPDebugCorePlugin.log(NLS.bind((String)Messages.PSourceLocator_5, (Object[])new Object[]{className}));
                            break block11;
                        }
                        IPSourceLocation location = null;
                        try {
                            location = (IPSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            PTPDebugCorePlugin.log(Messages.PSourceLocator_6);
                            break block11;
                        }
                        catch (InstantiationException instantiationException) {
                            PTPDebugCorePlugin.log(Messages.PSourceLocator_6);
                            break block11;
                        }
                        location.initializeFrom(data);
                        if (!sourceLocations.contains(location)) {
                            if (location instanceof PProjectSourceLocation) {
                                ((PProjectSourceLocation)location).setGenerated(this.isReferencedProject(((PProjectSourceLocation)location).getProject()));
                            }
                            sourceLocations.add(location);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private boolean isReferencedProject(IProject ref) {
        if (this.getProject() != null) {
            try {
                return Arrays.asList(this.getProject().getReferencedProjects()).contains(ref);
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
        }
        return false;
    }

    private void removeDisabledLocations(Element root, List<IPSourceLocation> sourceLocations) {
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        HashSet<String> disabledProjects = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(DISABLED_GENERIC_PROJECT_NAME)) {
                String projectName = entry.getAttribute(ATTR_PROJECT_NAME);
                if (this.isEmpty(projectName)) {
                    PTPDebugCorePlugin.log(Messages.PSourceLocator_4);
                }
                disabledProjects.add(projectName.trim());
            }
            ++i;
        }
        Iterator<IPSourceLocation> it = sourceLocations.iterator();
        while (it.hasNext()) {
            IPSourceLocation location = it.next();
            if (!(location instanceof IProjectSourceLocation) || !disabledProjects.contains(((IProjectSourceLocation)location).getProject().getName())) continue;
            it.remove();
        }
    }

    private void removeGenericSourceLocations() {
        this.fReferencedProjects.clear();
        IPSourceLocation[] locations = this.getSourceLocations();
        ArrayList<IPSourceLocation> newLocations = new ArrayList<IPSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            }
            ++i;
        }
        this.setSourceLocations(newLocations.toArray(new IPSourceLocation[newLocations.size()]));
    }

    private void resetSourceLocations(List<IResource> affectedProjects) {
        if (affectedProjects.size() != 0 && this.getProject() != null) {
            if (!this.getProject().exists() || !this.getProject().isOpen()) {
                this.removeGenericSourceLocations();
            } else {
                this.updateGenericSourceLocations(affectedProjects);
            }
        }
    }

    private void saveAdditionalSourceLocations(IPSourceLocation[] locations, Document doc, Element node) {
        int i = 0;
        while (i < locations.length) {
            block4: {
                if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                    Element child = doc.createElement(ADDITIONAL_SOURCE_LOCATION_NAME);
                    child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                    try {
                        child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                    }
                    catch (CoreException e) {
                        PTPDebugCorePlugin.log(e);
                        break block4;
                    }
                    node.appendChild(child);
                }
            }
            ++i;
        }
    }

    private void saveDisabledGenericSourceLocations(IPSourceLocation[] locations, Document doc, Element node) {
        IProject project = this.getProject();
        if (project != null && project.exists() && project.isOpen()) {
            List<IProject> list = PDebugUtils.getReferencedProjects(project);
            HashSet<String> names = new HashSet<String>(list.size() + 1);
            names.add(project.getName());
            Iterator<Object> it = list.iterator();
            while (it.hasNext()) {
                names.add(it.next().getName());
            }
            int i = 0;
            while (i < locations.length) {
                if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric()) {
                    names.remove(((IProjectSourceLocation)locations[i]).getProject().getName());
                }
                ++i;
            }
            it = names.iterator();
            while (it.hasNext()) {
                Element child = doc.createElement(DISABLED_GENERIC_PROJECT_NAME);
                child.setAttribute(ATTR_PROJECT_NAME, (String)it.next());
                node.appendChild(child);
            }
        }
    }

    private void setReferencedProjects() {
        this.fReferencedProjects.clear();
        this.fReferencedProjects = PDebugUtils.getReferencedProjects(this.getProject());
    }

    private void updateGenericSourceLocations(List<IResource> affectedProjects) {
        List<IProject> newRefs = PDebugUtils.getReferencedProjects(this.getProject());
        IPSourceLocation[] locations = this.getSourceLocations();
        ArrayList<IPSourceLocation> newLocations = new ArrayList<IPSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            } else {
                IProject project = ((IProjectSourceLocation)locations[i]).getProject();
                if (project.exists() && project.isOpen() && (newRefs.contains(project) || project.equals((Object)this.getProject()))) {
                    newLocations.add(locations[i]);
                    newRefs.remove(project);
                }
            }
            ++i;
        }
        for (IProject project : newRefs) {
            if (this.fReferencedProjects.contains(project)) continue;
            newLocations.add(SourceLookupFactory.createProjectSourceLocation(project));
        }
        this.fReferencedProjects = newRefs;
        this.setSourceLocations(newLocations.toArray(new IPSourceLocation[newLocations.size()]));
    }

    protected IPSourceLocation[] getDefaultSourceLocations() {
        Iterator<IProject> it = this.fReferencedProjects.iterator();
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>(this.fReferencedProjects.size());
        if (this.getProject() != null && this.getProject().exists() && this.getProject().isOpen()) {
            list.add(SourceLookupFactory.createProjectSourceLocation(this.getProject()));
        }
        while (it.hasNext()) {
            IProject project = it.next();
            if (project == null || !project.exists() || !project.isOpen()) continue;
            list.add(SourceLookupFactory.createProjectSourceLocation(project));
        }
        return list.toArray(new IPSourceLocation[list.size()]);
    }

    protected Object getInput(IStackFrame f) {
        if (f instanceof IPStackFrame) {
            IPStackFrame frame = (IPStackFrame)f;
            LinkedList<Object> list = new LinkedList<Object>();
            if (frame != null) {
                Object result = null;
                String fileName = frame.getFile();
                if (fileName != null && fileName.length() > 0) {
                    IPSourceLocation[] locations = this.getSourceLocations();
                    int i = 0;
                    while (i < locations.length) {
                        try {
                            result = locations[i].findSourceElement(fileName);
                        }
                        catch (CoreException coreException) {}
                        if (result != null) {
                            if (result instanceof List) {
                                list.addAll((List)result);
                            } else {
                                list.add(result);
                            }
                            if (!this.searchForDuplicateFiles()) break;
                        }
                        ++i;
                    }
                }
            }
            return list.size() > 0 ? (list.size() == 1 ? list.getFirst() : list) : null;
        }
        return null;
    }

    protected void setProject(IProject project) {
        this.fProject = project;
    }
}

