/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommandFactory;
import org.eclipse.ptp.proxy.command.IProxyCommandListener;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.server.IProxyServer;
import org.eclipse.ptp.proxy.util.compression.IDecoder;
import org.eclipse.ptp.proxy.util.compression.IEncoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteCompress;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteUncompress;

public abstract class AbstractProxyServer
implements IProxyServer {
    public static final int MAX_ERRORS = 5;
    protected ServerState state = ServerState.INIT;
    private final String sessHost;
    private final int sessPort;
    private SocketChannel sessSocket;
    private IEncoder compressor;
    private IDecoder uncompressor;
    private final IProxyCommandFactory proxyCommandFactory;
    private Thread commandThread;
    protected Thread stateMachineThread;
    private final List<IProxyCommandListener> listeners = Collections.synchronizedList(new ArrayList());

    public AbstractProxyServer(String host, int port, IProxyCommandFactory factory) {
        this.sessHost = host;
        this.sessPort = port;
        this.proxyCommandFactory = factory;
        this.compressor = new HuffmanByteCompress(ProxyPacket.getDefaultHuffmanTable());
        this.uncompressor = new HuffmanByteUncompress();
    }

    public void addListener(IProxyCommandListener listener) {
        this.listeners.add(listener);
    }

    public void connect() throws IOException {
        this.sessSocket = SocketChannel.open();
        this.sessSocket.connect(new InetSocketAddress(this.sessHost, this.sessPort));
    }

    protected void sendEvent(IProxyEvent event) throws IOException {
        ProxyPacket packet = new ProxyPacket(event, this.compressor);
        packet.send(this.sessSocket);
    }

    protected void fireProxyCommand(IProxyCommand cmd) {
        System.out.println("fireProxyCommand: " + cmd.getCommandID());
        for (IProxyCommandListener listener : this.listeners) {
            listener.handleCommand(cmd);
        }
    }

    public void removeListener(IProxyCommandListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void runStateMachine() throws InterruptedException, IOException;

    private boolean sessionProgress() throws IOException {
        ProxyPacket packet = new ProxyPacket(this.uncompressor);
        System.out.print("sessionProgress: ");
        if (!packet.read(this.sessSocket)) {
            System.out.println("false");
            return false;
        }
        System.out.println(String.valueOf(packet.getID()) + "," + packet.getTransID() + "," + packet.getArgs());
        IProxyCommand cmd = this.proxyCommandFactory.toCommand(packet);
        System.out.println("cmd: " + cmd);
        if (cmd != null) {
            this.fireProxyCommand(cmd);
            return true;
        }
        return false;
    }

    public void start() throws IOException {
        this.commandThread = new Thread("Proxy Server Command Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServerState serverState;
                boolean error = false;
                int errorCount = 0;
                System.out.println("server command thread starting...");
                try {
                    while (errorCount < 5 && !this.isInterrupted()) {
                        serverState = AbstractProxyServer.this.state;
                        synchronized (serverState) {
                            if (AbstractProxyServer.this.state == ServerState.SHUTDOWN) {
                                break;
                            }
                        }
                        if (AbstractProxyServer.this.sessionProgress()) continue;
                        ++errorCount;
                    }
                }
                catch (IOException e) {
                    ServerState serverState2 = AbstractProxyServer.this.state;
                    synchronized (serverState2) {
                        if (!this.isInterrupted() && AbstractProxyServer.this.state != ServerState.SHUTDOWN) {
                            error = true;
                            System.out.println("event thread IOException . . . " + e.getMessage());
                        }
                    }
                }
                if (errorCount >= 5) {
                    error = true;
                }
                try {
                    AbstractProxyServer.this.sessSocket.close();
                }
                catch (IOException iOException) {}
                serverState = AbstractProxyServer.this.state;
                synchronized (serverState) {
                    AbstractProxyServer.this.state = ServerState.SHUTDOWN;
                }
                System.out.println("server thread exited");
                if (error) {
                    System.out.println(" due to errors .. shutting down");
                    AbstractProxyServer.this.stateMachineThread.interrupt();
                } else {
                    System.out.println(" normally");
                }
            }
        };
        this.commandThread.start();
        try {
            this.stateMachineThread = Thread.currentThread();
            this.runStateMachine();
            this.commandThread.interrupt();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ServerState {
        INIT,
        DISCOVERY,
        NORMAL,
        SUSPENDED,
        SHUTDOWN;

    }
}

