/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractExecutor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiNestedEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiRootEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTracingEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;

public class BasicQVTiExecutor
extends AbstractExecutor
implements QVTiExecutor {
    protected final @NonNull Transformation transformation;
    private @Nullable QVTiTransformationAnalysis transformationAnalysis = null;
    private @Nullable QVTiModelManager modelManager = null;

    public BasicQVTiExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        super((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory);
        this.transformation = transformation;
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource resource) {
        this.getModelManager().addModel(typedModel, resource);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EvaluationVisitor.EvaluationVisitorExtension createEvaluationVisitor() {
        IQVTiEvaluationVisitor visitor = new QVTiEvaluationVisitor(this);
        if (this.environmentFactory.isEvaluationTracingEnabled()) {
            visitor = new QVTiTracingEvaluationVisitor(visitor);
        }
        return visitor;
    }

    @Override
    public void createModel(@NonNull String name, @NonNull URI modelURI, @Nullable String contentType) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.environmentFactory.getResourceSet().createResource(modelURI, contentType);
        if (resource != null) {
            this.getModelManager().addModel(typedModel, resource);
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createNestedEvaluationEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        if (evaluationEnvironment instanceof QVTiEvaluationEnvironment) {
            return new QVTiNestedEvaluationEnvironment((QVTiEvaluationEnvironment)evaluationEnvironment, executableObject, callingObject);
        }
        return super.createNestedEvaluationEnvironment(evaluationEnvironment, executableObject, callingObject);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createRootEvaluationEnvironment(@NonNull NamedElement executableObject) {
        if (executableObject instanceof Transformation) {
            return new QVTiRootEvaluationEnvironment(this, (Transformation)executableObject);
        }
        return super.createRootEvaluationEnvironment(executableObject);
    }

    public void dispose() {
        if (this.modelManager != null) {
            this.modelManager.dispose();
        }
        super.dispose();
    }

    protected void doCommits(@NonNull Mapping mapping, @NonNull EvaluationVisitor undecoratedVisitor) {
        for (Domain domain : mapping.getDomain()) {
            if (!domain.isIsEnforceable()) continue;
            CoreDomain enforceableDomain = (CoreDomain)domain;
            BottomPattern enforceableBottomPattern = enforceableDomain.getBottomPattern();
            for (RealizedVariable realizedVariable : enforceableBottomPattern.getRealizedVariable()) {
                OCLExpression ownedInit = realizedVariable.getOwnedInit();
                if (ownedInit == null) continue;
                Object initValue = ownedInit.accept((Visitor)undecoratedVisitor);
                this.getEvaluationEnvironment().add((TypedElement)realizedVariable, initValue);
                this.replace((TypedElement)realizedVariable, initValue);
                Area area = ((BottomPattern)realizedVariable.eContainer()).getArea();
                TypedModel typedModel = QVTcoreBaseUtil.getTypedModel((Area)area);
                assert (typedModel != null);
                Object ecoreValue = this.getIdResolver().ecoreValueOf(null, initValue);
                assert (ecoreValue != null);
                this.getModelManager().addModelElement(typedModel, ecoreValue);
            }
            for (RealizedVariable realizedVariable : enforceableBottomPattern.getRealizedVariable()) {
                if (realizedVariable.getOwnedInit() != null) continue;
                realizedVariable.accept((Visitor)undecoratedVisitor);
            }
        }
        BottomPattern middleBottomPattern = mapping.getBottomPattern();
        for (Assignment assignment : middleBottomPattern.getAssignment()) {
            if (assignment instanceof VariableAssignment) continue;
            assignment.accept((Visitor)undecoratedVisitor);
        }
        for (Domain domain : mapping.getDomain()) {
            if (!domain.isIsEnforceable()) continue;
            CoreDomain enforceableDomain = (CoreDomain)domain;
            BottomPattern enforceableBottomPattern = enforceableDomain.getBottomPattern();
            for (EnforcementOperation enforceOp : enforceableBottomPattern.getEnforcementOperation()) {
                enforceOp.accept((Visitor)undecoratedVisitor);
            }
        }
    }

    protected boolean doPredicatesAndEvaluations(@NonNull Mapping mapping, @NonNull EvaluationVisitor undecoratedVisitor) {
        GuardPattern middleGuardPattern = mapping.getGuardPattern();
        for (Predicate predicate : ClassUtil.nullFree((EList)middleGuardPattern.getPredicate())) {
            Object result = predicate.accept((Visitor)undecoratedVisitor);
            if (result == Boolean.TRUE) continue;
            return false;
        }
        for (Domain domain : ClassUtil.nullFree((EList)mapping.getDomain())) {
            OCLExpression ownedInit;
            if (!domain.isIsEnforceable()) {
                CoreDomain checkableDomain = (CoreDomain)domain;
                GuardPattern checkableGuardPattern = checkableDomain.getGuardPattern();
                assert (checkableGuardPattern.getPredicate().isEmpty());
                BottomPattern checkableBottomPattern = checkableDomain.getBottomPattern();
                assert (checkableBottomPattern.getAssignment().isEmpty());
                assert (checkableBottomPattern.getEnforcementOperation().isEmpty());
                assert (checkableBottomPattern.getPredicate().isEmpty());
                assert (checkableBottomPattern.getRealizedVariable().isEmpty());
                for (Variable rVar : ClassUtil.nullFree((EList)checkableBottomPattern.getVariable())) {
                    ownedInit = rVar.getOwnedInit();
                    assert (ownedInit == null);
                }
                continue;
            }
            CoreDomain enforceableDomain = (CoreDomain)domain;
            GuardPattern enforceableGuardPattern = enforceableDomain.getGuardPattern();
            assert (enforceableGuardPattern.getPredicate().isEmpty());
            BottomPattern enforceableBottomPattern = enforceableDomain.getBottomPattern();
            assert (enforceableBottomPattern.getAssignment().isEmpty());
            assert (enforceableBottomPattern.getPredicate().isEmpty());
            for (Variable rVar : ClassUtil.nullFree((EList)enforceableBottomPattern.getVariable())) {
                ownedInit = rVar.getOwnedInit();
                if (ownedInit == null) continue;
                Object initValue = ownedInit.accept((Visitor)undecoratedVisitor);
                this.replace((TypedElement)rVar, initValue);
            }
        }
        BottomPattern middleBottomPattern = mapping.getBottomPattern();
        assert (middleBottomPattern.getEnforcementOperation().isEmpty());
        assert (middleBottomPattern.getRealizedVariable().isEmpty());
        for (Variable rVar : ClassUtil.nullFree((EList)middleBottomPattern.getVariable())) {
            if (rVar instanceof ConnectionVariable) {
                CollectionValue.Accumulator accumulator = ValueUtil.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)rVar.getTypeId()));
                OCLExpression ownedInit = rVar.getOwnedInit();
                if (ownedInit != null) {
                    Object initValue = ownedInit.accept((Visitor)undecoratedVisitor);
                    accumulator = ValueUtil.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)ownedInit.getTypeId()));
                    if (initValue != null) {
                        for (Object value : (Iterable)initValue) {
                            accumulator.add(value);
                        }
                    }
                } else {
                    accumulator = ValueUtil.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)rVar.getTypeId()));
                }
                this.replace((TypedElement)rVar, accumulator);
                continue;
            }
            OCLExpression ownedInit = rVar.getOwnedInit();
            if (ownedInit == null) continue;
            Object initValue = ownedInit.accept((Visitor)undecoratedVisitor);
            this.replace((TypedElement)rVar, initValue);
        }
        for (Assignment assignment : ClassUtil.nullFree((EList)middleBottomPattern.getAssignment())) {
            if (!(assignment instanceof VariableAssignment)) continue;
            assignment.accept((Visitor)undecoratedVisitor);
        }
        for (Predicate predicate : ClassUtil.nullFree((EList)middleBottomPattern.getPredicate())) {
            Object result = predicate.accept((Visitor)undecoratedVisitor);
            if (result == Boolean.TRUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean execute() {
        this.initializeEvaluationEnvironment((NamedElement)this.transformation);
        this.getRootEvaluationEnvironment();
        StandardLibraryInternal standardLibrary = this.environmentFactory.getStandardLibrary();
        Variable ownedContext = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)this.transformation);
        QVTiModelManager modelManager = this.getModelManager();
        this.add((TypedElement)ownedContext, modelManager.getTransformationInstance(this.transformation));
        for (TypedModel typedModel : this.transformation.getModelParameter()) {
            if (typedModel == null) continue;
            ownedContext = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (TypedModel)typedModel);
            this.add((TypedElement)ownedContext, modelManager.getTypedModelInstance(typedModel));
        }
        return this.executeInternal();
    }

    protected Boolean executeInternal() {
        return (Boolean)this.getEvaluationVisitor().visit((Visitable)this.transformation);
    }

    public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
        return (QVTiEnvironmentFactory)super.getEnvironmentFactory();
    }

    @Override
    public @NonNull QVTiEvaluationEnvironment getEvaluationEnvironment() {
        return (QVTiEvaluationEnvironment)super.getEvaluationEnvironment();
    }

    @Override
    public @Nullable Resource getModel(@NonNull String name) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        return this.getModelManager().getModel(typedModel);
    }

    @Override
    public @NonNull QVTiModelManager getModelManager() {
        QVTiModelManager modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            this.modelManager = modelManager2 = new QVTiModelManager(this.getTransformationAnalysis());
        }
        return modelManager2;
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull QVTiTransformationAnalysis getTransformationAnalysis() {
        QVTiTransformationAnalysis transformationAnalysis2 = this.transformationAnalysis;
        if (transformationAnalysis2 == null) {
            this.transformationAnalysis = transformationAnalysis2 = this.getEnvironmentFactory().createTransformationAnalysis();
            transformationAnalysis2.analyzeTransformation(this.transformation);
        }
        return transformationAnalysis2;
    }

    @Override
    public @Nullable Object internalExecuteMappingCall(@NonNull MappingCall mappingCall, @NonNull Map<Variable, Object> variable2value, @NonNull EvaluationVisitor undecoratedVisitor) {
        Mapping calledMapping = mappingCall.getReferredMapping();
        if (calledMapping != null) {
            this.pushEvaluationEnvironment((NamedElement)calledMapping, mappingCall);
            try {
                for (Map.Entry<Variable, Object> entry : variable2value.entrySet()) {
                    @NonNull Variable variable = entry.getKey();
                    this.replace((TypedElement)variable, entry.getValue());
                }
                calledMapping.accept((Visitor)undecoratedVisitor);
            }
            finally {
                this.popEvaluationEnvironment();
            }
        }
        return true;
    }

    @Override
    public @Nullable Object internalExecuteMapping(@NonNull Mapping mapping, @NonNull EvaluationVisitor undecoratedVisitor) {
        try {
            if (!this.doPredicatesAndEvaluations(mapping, undecoratedVisitor)) {
                return false;
            }
        }
        catch (InvocationFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            AbstractTransformer.EXCEPTIONS.println("Execution failure in " + mapping.getName() + " : " + e);
            return false;
        }
        this.doCommits(mapping, undecoratedVisitor);
        MappingStatement mappingStatement = mapping.getMappingStatement();
        if (mappingStatement != null) {
            mappingStatement.accept((Visitor)undecoratedVisitor);
        }
        return true;
    }

    @Override
    public void internalExecuteNavigationAssignment(@NonNull NavigationAssignment navigationAssignment, @NonNull Object slotObject, @Nullable Object ecoreValue, @Nullable Object childKey) {
        Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        targetProperty.initValue(slotObject, ecoreValue);
        QVTiModelManager modelManager = this.getModelManager();
        Integer cacheIndex = modelManager.getTransformationAnalysis().getCacheIndex(navigationAssignment);
        if (cacheIndex != null) {
            modelManager.setUnnavigableOpposite(cacheIndex, slotObject, ecoreValue);
        }
    }

    @Override
    public @Nullable Object internalExecuteRealizedVariable(@NonNull RealizedVariable realizedVariable, @NonNull EvaluationVisitor undecoratedVisitor) {
        Type type = realizedVariable.getType();
        if (!(type instanceof Class)) {
            return null;
        }
        Area area = ((BottomPattern)realizedVariable.eContainer()).getArea();
        TypedModel typedModel = QVTcoreBaseUtil.getTypedModel((Area)area);
        assert (typedModel != null);
        EObject element = ((Class)type).createInstance();
        this.replace((TypedElement)realizedVariable, element);
        this.getModelManager().addModelElement(typedModel, element);
        return element;
    }

    @Override
    public @Nullable Object internalExecuteTransformation(@NonNull Transformation transformation, @NonNull EvaluationVisitor undecoratedVisitor) {
        Rule rule = (Rule)NameUtil.getNameable((Iterable)transformation.getRule(), (String)"__root__");
        if (rule == null) {
            throw new IllegalStateException("Transformation " + transformation.getName() + " has no root mapping");
        }
        OperationCallExp callExp = PivotFactory.eINSTANCE.createOperationCallExp();
        this.pushEvaluationEnvironment((NamedElement)rule, (OCLExpression)callExp);
        try {
            rule.accept((Visitor)undecoratedVisitor);
        }
        finally {
            this.popEvaluationEnvironment();
        }
        return true;
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.environmentFactory.getResourceSet().getResource(modelURI, true);
        if (resource != null) {
            this.getModelManager().addModel(typedModel, resource);
        }
    }

    @Override
    public void loadModel(@NonNull String name, @NonNull URI modelURI, @Nullable String contentType) {
        Resource resource;
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        if (contentType == null) {
            resource = resourceSet.getResource(modelURI, true);
        } else {
            resource = resourceSet.createResource(modelURI, contentType);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (resource != null) {
            this.getModelManager().addModel(typedModel, resource);
        }
    }

    public void replace(@NonNull TypedElement asVariable, @Nullable Object value) {
        if (value == null) {
            if (asVariable.isIsRequired()) {
                throw new InvalidValueException("Attempted to assign null value to " + asVariable, new Object[0]);
            }
        } else if (!(value instanceof Throwable)) {
            Type valueType = this.getIdResolver().getDynamicTypeOf(value);
            Type variableType = (Type)ClassUtil.nonNullState((Object)asVariable.getType());
            if (!valueType.conformsTo(this.getStandardLibrary(), variableType) && variableType.getESObject() != EcorePackage.Literals.EOBJECT) {
                throw new InvalidValueException("Attempted to assign incompatible value to " + asVariable, new Object[0]);
            }
        }
        super.replace(asVariable, value);
    }

    public Resource saveModel(@NonNull String name, @NonNull URI modelURI, String contentType, @Nullable Map<?, ?> savingOptions) throws IOException {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.getModelManager().getModel(typedModel);
        if (resource == null) {
            resource = this.environmentFactory.getResourceSet().createResource(modelURI, contentType);
        }
        if (resource != null) {
            resource.save(savingOptions);
        }
        return resource;
    }

    @Override
    public void saveModels() {
        this.getModelManager().saveModels();
    }

    public void saveModels(@Nullable Map<?, ?> savingOptions) {
        this.getModelManager().saveModels(savingOptions);
    }

    public void saveModels(@NonNull URI traceURI) {
        this.saveModels(traceURI, null);
    }

    public void saveModels(@NonNull URI traceURI, @Nullable Map<?, ?> savingOptions) {
        this.saveModels(savingOptions);
        this.getModelManager().saveMiddleModel(traceURI, savingOptions);
    }

    public void saveTransformation(Map<?, ?> options) throws IOException {
        XMLResource resource = (XMLResource)this.transformation.eResource();
        resource.save(options);
    }
}

